/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsnamespaces;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.models.ResponseError;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.metricsnamespaces.MetricsNamespacesClientImpl;
import com.azure.monitor.query.implementation.metricsnamespaces.models.ErrorResponseException;
import com.azure.monitor.query.implementation.metricsnamespaces.models.MetricNamespace;
import com.azure.monitor.query.implementation.metricsnamespaces.models.MetricNamespaceCollection;
import reactor.core.publisher.Mono;

public final class MetricNamespacesImpl {
    private final MetricNamespacesService service;
    private final MetricsNamespacesClientImpl client;

    MetricNamespacesImpl(MetricsNamespacesClientImpl client) {
        this.service = (MetricNamespacesService)RestProxy.create(MetricNamespacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricNamespace>> listSinglePageAsync(String resourceUri, String startTime) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getHost(), resourceUri, this.client.getApiVersion(), startTime, "application/json", (Context)context)).onErrorMap(ErrorResponseException.class, ex -> new HttpResponseException(ex.getMessage(), ex.getResponse(), (Object)new ResponseError(ex.getValue().getCode(), ex.getValue().getMessage()))).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricNamespaceCollection)res.getValue()).getValue(), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<MetricNamespace>> listSinglePageAsync(String resourceUri, String startTime, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.list(this.client.getHost(), resourceUri, this.client.getApiVersion(), startTime, "application/json", context).onErrorMap(ErrorResponseException.class, ex -> new HttpResponseException(ex.getMessage(), ex.getResponse(), (Object)new ResponseError(ex.getValue().getCode(), ex.getValue().getMessage()))).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricNamespaceCollection)res.getValue()).getValue(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricNamespace> listAsync(String resourceUri, String startTime) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, startTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricNamespace> listAsync(String resourceUri, String startTime, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, startTime, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricNamespace> list(String resourceUri, String startTime) {
        return new PagedIterable(this.listAsync(resourceUri, startTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricNamespace> list(String resourceUri, String startTime, Context context) {
        return new PagedIterable(this.listAsync(resourceUri, startTime, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MetricsNamespacesCli")
    public static interface MetricNamespacesService {
        @Get(value="/{resourceUri}/providers/microsoft.insights/metricNamespaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<MetricNamespaceCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="startTime") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

