/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.models;

import com.azure.core.util.BinaryData;
import com.azure.monitor.query.models.LogsColumnType;
import java.time.OffsetDateTime;

public final class LogsTableCell {
    private final String columnName;
    private final LogsColumnType columnType;
    private final int columnIndex;
    private final int rowIndex;
    private final String rowValue;

    public LogsTableCell(String columnName, LogsColumnType columnType, int columnIndex, int rowIndex, Object rowValue) {
        this.columnName = columnName;
        this.columnType = columnType;
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.rowValue = rowValue == null ? null : rowValue.toString();
    }

    public LogsColumnType getColumnType() {
        return this.columnType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public String getValueAsString() {
        return this.rowValue == null ? null : this.rowValue;
    }

    public Boolean getValueAsBoolean() {
        return this.rowValue == null ? null : Boolean.valueOf(this.rowValue);
    }

    public Integer getValueAsInteger() {
        return this.rowValue == null ? null : Integer.valueOf(Integer.parseInt(this.rowValue));
    }

    public Double getValueAsDouble() {
        return this.rowValue == null ? null : Double.valueOf(Double.parseDouble(this.rowValue));
    }

    public Long getValueAsLong() {
        return this.rowValue == null ? null : Long.valueOf(Long.parseLong(this.rowValue));
    }

    public BinaryData getValueAsDynamic() {
        return this.rowValue == null ? null : BinaryData.fromString((String)this.rowValue);
    }

    public OffsetDateTime getValueAsDateTime() {
        return this.rowValue == null ? null : OffsetDateTime.parse(this.rowValue);
    }
}

