// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.metricsdefinitions.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Represents collection of metric definitions. */
@Fluent
public final class MetricDefinitionCollection {
    /*
     * the values for the metric definitions.
     */
    @JsonProperty(value = "value", required = true)
    private List<MetricDefinition> value;

    /**
     * Creates an instance of MetricDefinitionCollection class.
     *
     * @param value the value value to set.
     */
    @JsonCreator
    public MetricDefinitionCollection(@JsonProperty(value = "value", required = true) List<MetricDefinition> value) {
        this.value = value;
    }

    /**
     * Get the value property: the values for the metric definitions.
     *
     * @return the value value.
     */
    public List<MetricDefinition> getValue() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getValue() == null) {
            throw new IllegalArgumentException("Missing required property value in model MetricDefinitionCollection");
        } else {
            getValue().forEach(e -> e.validate());
        }
    }
}
