/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.models.ResponseError;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.monitor.query.MetricsQueryClientBuilder;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.implementation.metrics.MonitorManagementClientImpl;
import com.azure.monitor.query.implementation.metrics.models.ErrorResponseException;
import com.azure.monitor.query.implementation.metrics.models.MetadataValue;
import com.azure.monitor.query.implementation.metrics.models.Metric;
import com.azure.monitor.query.implementation.metrics.models.MetricValue;
import com.azure.monitor.query.implementation.metrics.models.MetricsHelper;
import com.azure.monitor.query.implementation.metrics.models.MetricsResponse;
import com.azure.monitor.query.implementation.metrics.models.ResultType;
import com.azure.monitor.query.implementation.metrics.models.TimeSeriesElement;
import com.azure.monitor.query.implementation.metricsdefinitions.MetricsDefinitionsClientImpl;
import com.azure.monitor.query.implementation.metricsdefinitions.models.LocalizableString;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricAvailability;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricDefinition;
import com.azure.monitor.query.implementation.metricsnamespaces.MetricsNamespacesClientImpl;
import com.azure.monitor.query.implementation.metricsnamespaces.models.MetricNamespace;
import com.azure.monitor.query.models.MetricResult;
import com.azure.monitor.query.models.MetricsQueryOptions;
import com.azure.monitor.query.models.MetricsQueryResult;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MetricsQueryClientBuilder.class, isAsync=true)
public final class MetricsQueryAsyncClient {
    private final MonitorManagementClientImpl metricsClient;
    private final MetricsNamespacesClientImpl metricsNamespaceClient;
    private final MetricsDefinitionsClientImpl metricsDefinitionsClient;

    MetricsQueryAsyncClient(MonitorManagementClientImpl metricsClient, MetricsNamespacesClientImpl metricsNamespaceClient, MetricsDefinitionsClientImpl metricsDefinitionsClients) {
        this.metricsClient = metricsClient;
        this.metricsNamespaceClient = metricsNamespaceClient;
        this.metricsDefinitionsClient = metricsDefinitionsClients;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsQueryResult> queryResource(String resourceUri, List<String> metricsNames) {
        return this.queryResourceWithResponse(resourceUri, metricsNames, new MetricsQueryOptions()).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsQueryResult>> queryResourceWithResponse(String resourceUri, List<String> metricsNames, MetricsQueryOptions options) {
        return FluxUtil.withContext(context -> this.queryResourceWithResponse(resourceUri, metricsNames, options, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<com.azure.monitor.query.models.MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime) {
        return this.metricsNamespaceClient.getMetricNamespaces().listAsync(resourceUri, startTime.toString()).mapPage(this::mapMetricNamespace);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<com.azure.monitor.query.models.MetricDefinition> listMetricDefinitions(String resourceUri) {
        return this.listMetricDefinitions(resourceUri, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<com.azure.monitor.query.models.MetricDefinition> listMetricDefinitions(String resourceUri, String metricsNamespace) {
        return this.metricsDefinitionsClient.getMetricDefinitions().listAsync(resourceUri, metricsNamespace).mapPage(this::mapToMetricDefinition);
    }

    private com.azure.monitor.query.models.MetricDefinition mapToMetricDefinition(MetricDefinition definition) {
        com.azure.monitor.query.models.MetricDefinition metricDefinition = new com.azure.monitor.query.models.MetricDefinition();
        List<String> dimensions = null;
        if (!CoreUtils.isNullOrEmpty(definition.getDimensions())) {
            dimensions = definition.getDimensions().stream().map(LocalizableString::getValue).collect(Collectors.toList());
        }
        MetricsHelper.setMetricDefinitionProperties(metricDefinition, definition.isDimensionRequired(), definition.getResourceId(), definition.getNamespace(), definition.getName().getValue(), definition.getDisplayDescription(), definition.getCategory(), definition.getMetricClass(), definition.getUnit(), definition.getPrimaryAggregationType(), definition.getSupportedAggregationTypes(), this.mapMetricAvailabilities(definition.getMetricAvailabilities()), definition.getId(), dimensions);
        return metricDefinition;
    }

    private List<com.azure.monitor.query.models.MetricAvailability> mapMetricAvailabilities(List<MetricAvailability> metricAvailabilities) {
        return metricAvailabilities.stream().map(availabilityImpl -> {
            com.azure.monitor.query.models.MetricAvailability metricAvailability = new com.azure.monitor.query.models.MetricAvailability();
            MetricsHelper.setMetricAvailabilityProperties(metricAvailability, availabilityImpl.getRetention(), availabilityImpl.getTimeGrain());
            return metricAvailability;
        }).collect(Collectors.toList());
    }

    PagedFlux<com.azure.monitor.query.models.MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime, Context context) {
        return this.metricsNamespaceClient.getMetricNamespaces().listAsync(resourceUri, startTime == null ? null : startTime.toString(), context).mapPage(this::mapMetricNamespace);
    }

    private com.azure.monitor.query.models.MetricNamespace mapMetricNamespace(MetricNamespace namespaceImpl) {
        com.azure.monitor.query.models.MetricNamespace metricNamespace = new com.azure.monitor.query.models.MetricNamespace();
        MetricsHelper.setMetricNamespaceProperties(metricNamespace, namespaceImpl.getClassification(), namespaceImpl.getId(), namespaceImpl.getName(), namespaceImpl.getProperties() == null ? null : namespaceImpl.getProperties().getMetricNamespaceName(), namespaceImpl.getType());
        return metricNamespace;
    }

    PagedFlux<com.azure.monitor.query.models.MetricDefinition> listMetricDefinitions(String resourceUri, String metricsNamespace, Context context) {
        return this.metricsDefinitionsClient.getMetricDefinitions().listAsync(resourceUri, metricsNamespace, context).mapPage(this::mapToMetricDefinition);
    }

    Mono<Response<MetricsQueryResult>> queryResourceWithResponse(String resourceUri, List<String> metricsNames, MetricsQueryOptions options, Context context) {
        String aggregation = null;
        if (!CoreUtils.isNullOrEmpty(options.getAggregations())) {
            aggregation = options.getAggregations().stream().map(type -> type.toString()).collect(Collectors.joining(","));
        }
        String timespan = options.getTimeInterval() == null ? null : LogsQueryHelper.toIso8601Format(options.getTimeInterval());
        return this.metricsClient.getMetrics().listWithResponseAsync(resourceUri, timespan, options.getGranularity(), String.join((CharSequence)",", metricsNames), aggregation, options.getTop(), options.getOrderBy(), options.getFilter(), ResultType.DATA, options.getMetricNamespace(), context).map(response -> this.convertToMetricsQueryResult((Response<MetricsResponse>)response)).onErrorMap(ErrorResponseException.class, ex -> new HttpResponseException(ex.getMessage(), ex.getResponse(), (Object)new ResponseError(ex.getValue().getCode(), ex.getValue().getMessage())));
    }

    private Response<MetricsQueryResult> convertToMetricsQueryResult(Response<MetricsResponse> response) {
        MetricsResponse metricsResponse = (MetricsResponse)response.getValue();
        MetricsQueryResult metricsQueryResult = new MetricsQueryResult(metricsResponse.getCost(), metricsResponse.getTimespan() == null ? null : QueryTimeInterval.parse(metricsResponse.getTimespan()), metricsResponse.getInterval(), metricsResponse.getNamespace(), metricsResponse.getResourceregion(), this.mapMetrics(metricsResponse.getValue()));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)metricsQueryResult);
    }

    private List<MetricResult> mapMetrics(List<Metric> value) {
        return value.stream().map(metric -> new MetricResult(metric.getId(), metric.getType(), metric.getUnit(), metric.getName().getValue(), this.mapTimeSeries(metric.getTimeseries()), metric.getDisplayDescription(), new ResponseError(metric.getErrorCode(), metric.getErrorMessage()))).collect(Collectors.toList());
    }

    private List<com.azure.monitor.query.models.TimeSeriesElement> mapTimeSeries(List<TimeSeriesElement> timeseries) {
        return timeseries.stream().map(timeSeriesElement -> new com.azure.monitor.query.models.TimeSeriesElement(this.mapMetricsData(timeSeriesElement.getData()), this.mapMetricsMetadata(timeSeriesElement.getMetadatavalues()))).collect(Collectors.toList());
    }

    private Map<String, String> mapMetricsMetadata(List<MetadataValue> metadataValues) {
        if (metadataValues == null) {
            return null;
        }
        return metadataValues.stream().collect(Collectors.toMap(value -> value.getName().getValue(), MetadataValue::getValue));
    }

    private List<com.azure.monitor.query.models.MetricValue> mapMetricsData(List<MetricValue> data) {
        return data.stream().map(metricValue -> new com.azure.monitor.query.models.MetricValue(metricValue.getTimeStamp(), metricValue.getAverage(), metricValue.getMinimum(), metricValue.getMaximum(), metricValue.getTotal(), metricValue.getCount())).collect(Collectors.toList());
    }
}

