// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The related metadata items for the function. */
@Fluent
public final class MetadataFunctionRelated {
    /*
     * The related tables for the function.
     */
    @JsonProperty(value = "tables")
    private List<String> tables;

    /*
     * The related Log Analytics solutions for the function.
     */
    @JsonProperty(value = "solutions")
    private List<String> solutions;

    /*
     * The related resource types for the function.
     */
    @JsonProperty(value = "resourceTypes")
    private List<String> resourceTypes;

    /*
     * The related categories for the function.
     */
    @JsonProperty(value = "categories")
    private List<String> categories;

    /*
     * The related workspaces for the function.
     */
    @JsonProperty(value = "workspaces")
    private List<String> workspaces;

    /**
     * Get the tables property: The related tables for the function.
     *
     * @return the tables value.
     */
    public List<String> getTables() {
        return this.tables;
    }

    /**
     * Set the tables property: The related tables for the function.
     *
     * @param tables the tables value to set.
     * @return the MetadataFunctionRelated object itself.
     */
    public MetadataFunctionRelated setTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the solutions property: The related Log Analytics solutions for the function.
     *
     * @return the solutions value.
     */
    public List<String> getSolutions() {
        return this.solutions;
    }

    /**
     * Set the solutions property: The related Log Analytics solutions for the function.
     *
     * @param solutions the solutions value to set.
     * @return the MetadataFunctionRelated object itself.
     */
    public MetadataFunctionRelated setSolutions(List<String> solutions) {
        this.solutions = solutions;
        return this;
    }

    /**
     * Get the resourceTypes property: The related resource types for the function.
     *
     * @return the resourceTypes value.
     */
    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes property: The related resource types for the function.
     *
     * @param resourceTypes the resourceTypes value to set.
     * @return the MetadataFunctionRelated object itself.
     */
    public MetadataFunctionRelated setResourceTypes(List<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the categories property: The related categories for the function.
     *
     * @return the categories value.
     */
    public List<String> getCategories() {
        return this.categories;
    }

    /**
     * Set the categories property: The related categories for the function.
     *
     * @param categories the categories value to set.
     * @return the MetadataFunctionRelated object itself.
     */
    public MetadataFunctionRelated setCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    /**
     * Get the workspaces property: The related workspaces for the function.
     *
     * @return the workspaces value.
     */
    public List<String> getWorkspaces() {
        return this.workspaces;
    }

    /**
     * Set the workspaces property: The related workspaces for the function.
     *
     * @param workspaces the workspaces value to set.
     * @return the MetadataFunctionRelated object itself.
     */
    public MetadataFunctionRelated setWorkspaces(List<String> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
