// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The related metadata items for the Log Analytics solution. */
@Fluent
public final class MetadataSolutionRelated {
    /*
     * The tables related to the Log Analytics solution
     */
    @JsonProperty(value = "tables", required = true)
    private List<String> tables;

    /*
     * The functions related to the Log Analytics solution
     */
    @JsonProperty(value = "functions")
    private List<String> functions;

    /*
     * The categories related to the Log Analytics solution
     */
    @JsonProperty(value = "categories")
    private List<String> categories;

    /*
     * The saved queries related to the Log Analytics solution
     */
    @JsonProperty(value = "queries")
    private List<String> queries;

    /*
     * The Workspaces referenced in the metadata request that are related to
     * the Log Analytics solution
     */
    @JsonProperty(value = "workspaces")
    private List<String> workspaces;

    /**
     * Creates an instance of MetadataSolutionRelated class.
     *
     * @param tables the tables value to set.
     */
    @JsonCreator
    public MetadataSolutionRelated(@JsonProperty(value = "tables", required = true) List<String> tables) {
        this.tables = tables;
    }

    /**
     * Get the tables property: The tables related to the Log Analytics solution.
     *
     * @return the tables value.
     */
    public List<String> getTables() {
        return this.tables;
    }

    /**
     * Get the functions property: The functions related to the Log Analytics solution.
     *
     * @return the functions value.
     */
    public List<String> getFunctions() {
        return this.functions;
    }

    /**
     * Set the functions property: The functions related to the Log Analytics solution.
     *
     * @param functions the functions value to set.
     * @return the MetadataSolutionRelated object itself.
     */
    public MetadataSolutionRelated setFunctions(List<String> functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Get the categories property: The categories related to the Log Analytics solution.
     *
     * @return the categories value.
     */
    public List<String> getCategories() {
        return this.categories;
    }

    /**
     * Set the categories property: The categories related to the Log Analytics solution.
     *
     * @param categories the categories value to set.
     * @return the MetadataSolutionRelated object itself.
     */
    public MetadataSolutionRelated setCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    /**
     * Get the queries property: The saved queries related to the Log Analytics solution.
     *
     * @return the queries value.
     */
    public List<String> getQueries() {
        return this.queries;
    }

    /**
     * Set the queries property: The saved queries related to the Log Analytics solution.
     *
     * @param queries the queries value to set.
     * @return the MetadataSolutionRelated object itself.
     */
    public MetadataSolutionRelated setQueries(List<String> queries) {
        this.queries = queries;
        return this;
    }

    /**
     * Get the workspaces property: The Workspaces referenced in the metadata request that are related to the Log
     * Analytics solution.
     *
     * @return the workspaces value.
     */
    public List<String> getWorkspaces() {
        return this.workspaces;
    }

    /**
     * Set the workspaces property: The Workspaces referenced in the metadata request that are related to the Log
     * Analytics solution.
     *
     * @param workspaces the workspaces value to set.
     * @return the MetadataSolutionRelated object itself.
     */
    public MetadataSolutionRelated setWorkspaces(List<String> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getTables() == null) {
            throw new IllegalArgumentException("Missing required property tables in model MetadataSolutionRelated");
        }
    }
}
