// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Tables are part of the workspace schema, and contain a list of columns and a reference to other relevant metadata
 * items.
 */
@Fluent
public final class MetadataTable {
    /*
     * The ID of the table
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The name of the table
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The description of the table
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The column associated with the timespan query parameter for the table
     */
    @JsonProperty(value = "timespanColumn")
    private String timespanColumn;

    /*
     * The user defined labels of the table
     */
    @JsonProperty(value = "labels")
    private List<String> labels;

    /*
     * The tags associated with the table
     */
    @JsonProperty(value = "tags")
    private Object tags;

    /*
     * The properties of the table
     */
    @JsonProperty(value = "properties")
    private Object properties;

    /*
     * The list of columns defined on the table
     */
    @JsonProperty(value = "columns")
    private List<MetadataTableColumnsItem> columns;

    /*
     * The related metadata items for the table
     */
    @JsonProperty(value = "related")
    private MetadataTableRelated related;

    /**
     * Creates an instance of MetadataTable class.
     *
     * @param id the id value to set.
     * @param name the name value to set.
     */
    @JsonCreator
    public MetadataTable(
            @JsonProperty(value = "id", required = true) String id,
            @JsonProperty(value = "name", required = true) String name) {
        this.id = id;
        this.name = name;
    }

    /**
     * Get the id property: The ID of the table.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the name property: The name of the table.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the description property: The description of the table.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: The description of the table.
     *
     * @param description the description value to set.
     * @return the MetadataTable object itself.
     */
    public MetadataTable setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the timespanColumn property: The column associated with the timespan query parameter for the table.
     *
     * @return the timespanColumn value.
     */
    public String getTimespanColumn() {
        return this.timespanColumn;
    }

    /**
     * Set the timespanColumn property: The column associated with the timespan query parameter for the table.
     *
     * @param timespanColumn the timespanColumn value to set.
     * @return the MetadataTable object itself.
     */
    public MetadataTable setTimespanColumn(String timespanColumn) {
        this.timespanColumn = timespanColumn;
        return this;
    }

    /**
     * Get the labels property: The user defined labels of the table.
     *
     * @return the labels value.
     */
    public List<String> getLabels() {
        return this.labels;
    }

    /**
     * Set the labels property: The user defined labels of the table.
     *
     * @param labels the labels value to set.
     * @return the MetadataTable object itself.
     */
    public MetadataTable setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    /**
     * Get the tags property: The tags associated with the table.
     *
     * @return the tags value.
     */
    public Object getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags associated with the table.
     *
     * @param tags the tags value to set.
     * @return the MetadataTable object itself.
     */
    public MetadataTable setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: The properties of the table.
     *
     * @return the properties value.
     */
    public Object getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties of the table.
     *
     * @param properties the properties value to set.
     * @return the MetadataTable object itself.
     */
    public MetadataTable setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the columns property: The list of columns defined on the table.
     *
     * @return the columns value.
     */
    public List<MetadataTableColumnsItem> getColumns() {
        return this.columns;
    }

    /**
     * Set the columns property: The list of columns defined on the table.
     *
     * @param columns the columns value to set.
     * @return the MetadataTable object itself.
     */
    public MetadataTable setColumns(List<MetadataTableColumnsItem> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the related property: The related metadata items for the table.
     *
     * @return the related value.
     */
    public MetadataTableRelated getRelated() {
        return this.related;
    }

    /**
     * Set the related property: The related metadata items for the table.
     *
     * @param related the related value to set.
     * @return the MetadataTable object itself.
     */
    public MetadataTable setRelated(MetadataTableRelated related) {
        this.related = related;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getId() == null) {
            throw new IllegalArgumentException("Missing required property id in model MetadataTable");
        }
        if (getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model MetadataTable");
        }
        if (getColumns() != null) {
            getColumns().forEach(e -> e.validate());
        }
        if (getRelated() != null) {
            getRelated().validate();
        }
    }
}
