/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.logs.AzureLogAnalyticsImpl;
import com.azure.monitor.query.implementation.logs.models.ErrorResponseException;
import com.azure.monitor.query.implementation.logs.models.MetadataResults;
import reactor.core.publisher.Mono;

public final class MetadatasImpl {
    private final MetadatasService service;
    private final AzureLogAnalyticsImpl client;

    MetadatasImpl(AzureLogAnalyticsImpl client) {
        this.service = (MetadatasService)RestProxy.create(MetadatasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> getWithResponseAsync(String workspaceId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getHost(), workspaceId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> getWithResponseAsync(String workspaceId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.get(this.client.getHost(), workspaceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetadataResults> getAsync(String workspaceId) {
        return this.getWithResponseAsync(workspaceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetadataResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetadataResults> getAsync(String workspaceId, Context context) {
        return this.getWithResponseAsync(workspaceId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetadataResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetadataResults get(String workspaceId) {
        return (MetadataResults)this.getAsync(workspaceId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetadataResults> getWithResponse(String workspaceId, Context context) {
        return (Response)this.getWithResponseAsync(workspaceId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> postWithResponseAsync(String workspaceId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.post(this.client.getHost(), workspaceId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetadataResults>> postWithResponseAsync(String workspaceId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (workspaceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.post(this.client.getHost(), workspaceId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetadataResults> postAsync(String workspaceId) {
        return this.postWithResponseAsync(workspaceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetadataResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetadataResults> postAsync(String workspaceId, Context context) {
        return this.postWithResponseAsync(workspaceId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetadataResults)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetadataResults post(String workspaceId) {
        return (MetadataResults)this.postAsync(workspaceId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetadataResults> postWithResponse(String workspaceId, Context context) {
        return (Response)this.postWithResponseAsync(workspaceId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureLogAnalyticsMet")
    public static interface MetadatasService {
        @Get(value="/workspaces/{workspaceId}/metadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<MetadataResults>> get(@HostParam(value="$host") String var1, @PathParam(value="workspaceId") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/workspaces/{workspaceId}/metadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<MetadataResults>> post(@HostParam(value="$host") String var1, @PathParam(value="workspaceId") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

