/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.TypeReference;
import com.azure.monitor.query.implementation.logs.models.BatchQueryRequest;
import com.azure.monitor.query.models.LogsBatchQuery;
import com.azure.monitor.query.models.LogsColumnType;
import com.azure.monitor.query.models.LogsQueryOptions;
import com.azure.monitor.query.models.LogsTable;
import com.azure.monitor.query.models.LogsTableRow;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public final class LogsQueryHelper {
    private static final ClientLogger LOGGER = new ClientLogger(LogsQueryHelper.class);
    private static BatchQueryAccessor accessor;

    public static Duration getMaxServerTimeout(LogsBatchQuery query) {
        return accessor.getMaxServerTimeout(query);
    }

    public static void setAccessor(BatchQueryAccessor batchQueryAccessor) {
        accessor = batchQueryAccessor;
    }

    public static List<BatchQueryRequest> getBatchQueries(LogsBatchQuery query) {
        return accessor.getBatchQueries(query);
    }

    public static String buildPreferHeaderString(LogsQueryOptions options) {
        if (options == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (options.isIncludeVisualization()) {
            sb.append("include-render=true");
        }
        if (options.isIncludeStatistics()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("include-statistics=true");
        }
        if (options.getServerTimeout() != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("wait=");
            sb.append(options.getServerTimeout().getSeconds());
        }
        return sb.toString().isEmpty() ? null : sb.toString();
    }

    public static <T> List<T> toObject(LogsTable table, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (LogsTableRow tableRow : table.getRows()) {
            try {
                Object t = type.newInstance();
                Map<String, Field> declaredFieldMapping = Arrays.stream(type.getDeclaredFields()).collect(Collectors.toMap(field -> field.getName().toLowerCase(Locale.ROOT), field -> field));
                tableRow.getRow().stream().forEach(tableCell -> {
                    String columnName = tableCell.getColumnName();
                    try {
                        Field field = (Field)declaredFieldMapping.get(columnName.toLowerCase(Locale.ROOT));
                        if (field == null) {
                            return;
                        }
                        field.setAccessible(true);
                        if (tableCell.getColumnType() == LogsColumnType.BOOL) {
                            field.set(t, tableCell.getValueAsBoolean());
                        } else if (tableCell.getColumnType() == LogsColumnType.DATETIME) {
                            field.set(t, tableCell.getValueAsDateTime());
                        } else if (tableCell.getColumnType() == LogsColumnType.DYNAMIC) {
                            if (tableCell.getValueAsDynamic() != null) {
                                field.set(t, tableCell.getValueAsDynamic().toObject(TypeReference.createInstance(field.getType())));
                            }
                        } else if (tableCell.getColumnType() == LogsColumnType.INT) {
                            field.set(t, tableCell.getValueAsInteger());
                        } else if (tableCell.getColumnType() == LogsColumnType.LONG) {
                            field.set(t, tableCell.getValueAsLong());
                        } else if (tableCell.getColumnType() == LogsColumnType.REAL || tableCell.getColumnType() == LogsColumnType.DECIMAL) {
                            field.set(t, tableCell.getValueAsDouble());
                        } else if (tableCell.getColumnType() == LogsColumnType.STRING || tableCell.getColumnType() == LogsColumnType.GUID || tableCell.getColumnType() == LogsColumnType.TIMESPAN) {
                            field.set(t, tableCell.getValueAsString());
                        }
                        field.setAccessible(false);
                    }
                    catch (IllegalAccessException ex) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Failed to set column value for " + columnName, ex));
                    }
                });
                result.add(t);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot create an instance of class " + type.getName(), ex));
            }
        }
        return result;
    }

    public static String toIso8601Format(QueryTimeInterval timeInterval) {
        if (timeInterval.getStartTime() != null && timeInterval.getEndTime() != null) {
            return timeInterval.getStartTime() + "/" + timeInterval.getEndTime();
        }
        if (timeInterval.getStartTime() != null && timeInterval.getDuration() != null) {
            return timeInterval.getStartTime() + "/" + timeInterval.getDuration();
        }
        if (timeInterval.getDuration() != null && timeInterval.getEndTime() != null) {
            return timeInterval.getDuration() + "/" + timeInterval.getEndTime();
        }
        return timeInterval.getDuration() == null ? null : timeInterval.getDuration().toString();
    }

    public static interface BatchQueryAccessor {
        public List<BatchQueryRequest> getBatchQueries(LogsBatchQuery var1);

        public Duration getMaxServerTimeout(LogsBatchQuery var1);
    }
}

