/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.models;

import com.azure.core.util.CoreUtils;
import com.azure.monitor.query.implementation.logs.models.BatchQueryRequest;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.implementation.logs.models.QueryBody;
import com.azure.monitor.query.models.LogsQueryOptions;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class LogsBatchQuery {
    private final List<BatchQueryRequest> queries = new ArrayList<BatchQueryRequest>();
    private int index;
    private Duration maxServerTimeout;

    public String addWorkspaceQuery(String workspaceId, String query, QueryTimeInterval timeInterval) {
        return this.addWorkspaceQuery(workspaceId, query, timeInterval, new LogsQueryOptions());
    }

    public String addWorkspaceQuery(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions logsQueryOptions) {
        Objects.requireNonNull(query, "'query' cannot be null.");
        Objects.requireNonNull(workspaceId, "'workspaceId' cannot be null.");
        ++this.index;
        QueryBody queryBody = new QueryBody(query).setWorkspaces(logsQueryOptions == null ? null : logsQueryOptions.getAdditionalWorkspaces()).setTimespan(timeInterval == null ? null : LogsQueryHelper.toIso8601Format(timeInterval));
        String preferHeader = LogsQueryHelper.buildPreferHeaderString(logsQueryOptions);
        if (logsQueryOptions != null && logsQueryOptions.getServerTimeout() != null && (this.maxServerTimeout == null || logsQueryOptions.getServerTimeout().compareTo(this.maxServerTimeout) > 0)) {
            this.maxServerTimeout = logsQueryOptions.getServerTimeout();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!CoreUtils.isNullOrEmpty((CharSequence)preferHeader)) {
            headers.put("Prefer", preferHeader);
        }
        BatchQueryRequest batchQueryRequest = new BatchQueryRequest(String.valueOf(this.index), queryBody, workspaceId).setHeaders(headers).setPath("/query").setMethod("POST");
        this.queries.add(batchQueryRequest);
        return String.valueOf(this.index);
    }

    List<BatchQueryRequest> getBatchQueries() {
        return this.queries;
    }

    Duration getMaxServerTimeout() {
        return this.maxServerTimeout;
    }

    static {
        LogsQueryHelper.setAccessor(new LogsQueryHelper.BatchQueryAccessor(){

            @Override
            public List<BatchQueryRequest> getBatchQueries(LogsBatchQuery query) {
                return query.getBatchQueries();
            }

            @Override
            public Duration getMaxServerTimeout(LogsBatchQuery query) {
                return query.getMaxServerTimeout();
            }
        });
    }
}

