// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The related metadata items for the Application Insights app. */
@Fluent
public final class MetadataApplicationRelated {
    /*
     * The related tables for the Application Insights app.
     */
    @JsonProperty(value = "tables")
    private List<String> tables;

    /*
     * The related functions for the Application Insights app.
     */
    @JsonProperty(value = "functions")
    private List<String> functions;

    /** Creates an instance of MetadataApplicationRelated class. */
    public MetadataApplicationRelated() {}

    /**
     * Get the tables property: The related tables for the Application Insights app.
     *
     * @return the tables value.
     */
    public List<String> getTables() {
        return this.tables;
    }

    /**
     * Set the tables property: The related tables for the Application Insights app.
     *
     * @param tables the tables value to set.
     * @return the MetadataApplicationRelated object itself.
     */
    public MetadataApplicationRelated setTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the functions property: The related functions for the Application Insights app.
     *
     * @return the functions value.
     */
    public List<String> getFunctions() {
        return this.functions;
    }

    /**
     * Set the functions property: The related functions for the Application Insights app.
     *
     * @param functions the functions value to set.
     * @return the MetadataApplicationRelated object itself.
     */
    public MetadataApplicationRelated setFunctions(List<String> functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
