// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The related metadata items for the query. */
@Fluent
public final class MetadataQueryRelated {
    /*
     * The related categories for the query.
     */
    @JsonProperty(value = "categories")
    private List<String> categories;

    /*
     * The related Log Analytics solutions for the query.
     */
    @JsonProperty(value = "solutions")
    private List<String> solutions;

    /*
     * The related resource types for the query.
     */
    @JsonProperty(value = "resourceTypes")
    private List<String> resourceTypes;

    /*
     * The related tables for the query.
     */
    @JsonProperty(value = "tables")
    private List<String> tables;

    /** Creates an instance of MetadataQueryRelated class. */
    public MetadataQueryRelated() {}

    /**
     * Get the categories property: The related categories for the query.
     *
     * @return the categories value.
     */
    public List<String> getCategories() {
        return this.categories;
    }

    /**
     * Set the categories property: The related categories for the query.
     *
     * @param categories the categories value to set.
     * @return the MetadataQueryRelated object itself.
     */
    public MetadataQueryRelated setCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    /**
     * Get the solutions property: The related Log Analytics solutions for the query.
     *
     * @return the solutions value.
     */
    public List<String> getSolutions() {
        return this.solutions;
    }

    /**
     * Set the solutions property: The related Log Analytics solutions for the query.
     *
     * @param solutions the solutions value to set.
     * @return the MetadataQueryRelated object itself.
     */
    public MetadataQueryRelated setSolutions(List<String> solutions) {
        this.solutions = solutions;
        return this;
    }

    /**
     * Get the resourceTypes property: The related resource types for the query.
     *
     * @return the resourceTypes value.
     */
    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes property: The related resource types for the query.
     *
     * @param resourceTypes the resourceTypes value to set.
     * @return the MetadataQueryRelated object itself.
     */
    public MetadataQueryRelated setResourceTypes(List<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the tables property: The related tables for the query.
     *
     * @return the tables value.
     */
    public List<String> getTables() {
        return this.tables;
    }

    /**
     * Set the tables property: The related tables for the query.
     *
     * @param tables the tables value to set.
     * @return the MetadataQueryRelated object itself.
     */
    public MetadataQueryRelated setTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
