// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A type of resource in Azure.
 *
 * <p>Metadata about types of Azure resources, containing relevant tables, functions, etc.
 */
@Fluent
public final class MetadataResourceType {
    /*
     * The ID of the resource-type
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The type of the resource-type
     */
    @JsonProperty(value = "type", required = true)
    private String type;

    /*
     * The display name of the resource-type
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The description of the resource-type
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The user-defined labels of the resource-type
     */
    @JsonProperty(value = "labels")
    private List<String> labels;

    /*
     * The tags associated with the resource-type
     */
    @JsonProperty(value = "tags")
    private Object tags;

    /*
     * The properties of the resource-type
     */
    @JsonProperty(value = "properties")
    private Object properties;

    /*
     * The related metadata items for the resource-type
     */
    @JsonProperty(value = "related")
    private MetadataResourceTypeRelated related;

    /**
     * Creates an instance of MetadataResourceType class.
     *
     * @param id the id value to set.
     * @param type the type value to set.
     */
    @JsonCreator
    public MetadataResourceType(
            @JsonProperty(value = "id", required = true) String id,
            @JsonProperty(value = "type", required = true) String type) {
        this.id = id;
        this.type = type;
    }

    /**
     * Get the id property: The ID of the resource-type.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the type property: The type of the resource-type.
     *
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Get the displayName property: The display name of the resource-type.
     *
     * @return the displayName value.
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the resource-type.
     *
     * @param displayName the displayName value to set.
     * @return the MetadataResourceType object itself.
     */
    public MetadataResourceType setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The description of the resource-type.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: The description of the resource-type.
     *
     * @param description the description value to set.
     * @return the MetadataResourceType object itself.
     */
    public MetadataResourceType setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the labels property: The user-defined labels of the resource-type.
     *
     * @return the labels value.
     */
    public List<String> getLabels() {
        return this.labels;
    }

    /**
     * Set the labels property: The user-defined labels of the resource-type.
     *
     * @param labels the labels value to set.
     * @return the MetadataResourceType object itself.
     */
    public MetadataResourceType setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    /**
     * Get the tags property: The tags associated with the resource-type.
     *
     * @return the tags value.
     */
    public Object getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags associated with the resource-type.
     *
     * @param tags the tags value to set.
     * @return the MetadataResourceType object itself.
     */
    public MetadataResourceType setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: The properties of the resource-type.
     *
     * @return the properties value.
     */
    public Object getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties of the resource-type.
     *
     * @param properties the properties value to set.
     * @return the MetadataResourceType object itself.
     */
    public MetadataResourceType setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the related property: The related metadata items for the resource-type.
     *
     * @return the related value.
     */
    public MetadataResourceTypeRelated getRelated() {
        return this.related;
    }

    /**
     * Set the related property: The related metadata items for the resource-type.
     *
     * @param related the related value to set.
     * @return the MetadataResourceType object itself.
     */
    public MetadataResourceType setRelated(MetadataResourceTypeRelated related) {
        this.related = related;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getId() == null) {
            throw new IllegalArgumentException("Missing required property id in model MetadataResourceType");
        }
        if (getType() == null) {
            throw new IllegalArgumentException("Missing required property type in model MetadataResourceType");
        }
        if (getRelated() != null) {
            getRelated().validate();
        }
    }
}
