// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The related metadata items for the table. */
@Fluent
public final class MetadataTableRelated {
    /*
     * The related categories for the table
     */
    @JsonProperty(value = "categories")
    private List<String> categories;

    /*
     * The related Log Analytics solutions for the table
     */
    @JsonProperty(value = "solutions")
    private List<String> solutions;

    /*
     * The related resource types for the table
     */
    @JsonProperty(value = "resourceTypes")
    private List<String> resourceTypes;

    /*
     * The related Log Analytics workspaces for the table
     */
    @JsonProperty(value = "workspaces")
    private List<String> workspaces;

    /*
     * The related functions for the table
     */
    @JsonProperty(value = "functions")
    private List<String> functions;

    /*
     * The related saved queries for the table
     */
    @JsonProperty(value = "queries")
    private List<String> queries;

    /** Creates an instance of MetadataTableRelated class. */
    public MetadataTableRelated() {}

    /**
     * Get the categories property: The related categories for the table.
     *
     * @return the categories value.
     */
    public List<String> getCategories() {
        return this.categories;
    }

    /**
     * Set the categories property: The related categories for the table.
     *
     * @param categories the categories value to set.
     * @return the MetadataTableRelated object itself.
     */
    public MetadataTableRelated setCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    /**
     * Get the solutions property: The related Log Analytics solutions for the table.
     *
     * @return the solutions value.
     */
    public List<String> getSolutions() {
        return this.solutions;
    }

    /**
     * Set the solutions property: The related Log Analytics solutions for the table.
     *
     * @param solutions the solutions value to set.
     * @return the MetadataTableRelated object itself.
     */
    public MetadataTableRelated setSolutions(List<String> solutions) {
        this.solutions = solutions;
        return this;
    }

    /**
     * Get the resourceTypes property: The related resource types for the table.
     *
     * @return the resourceTypes value.
     */
    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes property: The related resource types for the table.
     *
     * @param resourceTypes the resourceTypes value to set.
     * @return the MetadataTableRelated object itself.
     */
    public MetadataTableRelated setResourceTypes(List<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the workspaces property: The related Log Analytics workspaces for the table.
     *
     * @return the workspaces value.
     */
    public List<String> getWorkspaces() {
        return this.workspaces;
    }

    /**
     * Set the workspaces property: The related Log Analytics workspaces for the table.
     *
     * @param workspaces the workspaces value to set.
     * @return the MetadataTableRelated object itself.
     */
    public MetadataTableRelated setWorkspaces(List<String> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    /**
     * Get the functions property: The related functions for the table.
     *
     * @return the functions value.
     */
    public List<String> getFunctions() {
        return this.functions;
    }

    /**
     * Set the functions property: The related functions for the table.
     *
     * @param functions the functions value to set.
     * @return the MetadataTableRelated object itself.
     */
    public MetadataTableRelated setFunctions(List<String> functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Get the queries property: The related saved queries for the table.
     *
     * @return the queries value.
     */
    public List<String> getQueries() {
        return this.queries;
    }

    /**
     * Set the queries property: The related saved queries for the table.
     *
     * @param queries the queries value to set.
     * @return the MetadataTableRelated object itself.
     */
    public MetadataTableRelated setQueries(List<String> queries) {
        this.queries = queries;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
