// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A Log Analytics workspace.
 *
 * <p>Log Analytics workspaces that were part of the metadata request and that the user has access to.
 */
@Fluent
public final class MetadataWorkspace {
    /*
     * The ID of the Log Analytics workspace.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The ARM resource ID of the Log Analytics workspace.
     */
    @JsonProperty(value = "resourceId", required = true)
    private String resourceId;

    /*
     * The name of the Log Analytics workspace.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The Azure region of the Log Analytics workspace.
     */
    @JsonProperty(value = "region", required = true)
    private String region;

    /*
     * The related metadata items for the Log Analytics workspace.
     */
    @JsonProperty(value = "related")
    private MetadataWorkspaceRelated related;

    /**
     * Creates an instance of MetadataWorkspace class.
     *
     * @param id the id value to set.
     * @param resourceId the resourceId value to set.
     * @param name the name value to set.
     * @param region the region value to set.
     */
    @JsonCreator
    public MetadataWorkspace(
            @JsonProperty(value = "id", required = true) String id,
            @JsonProperty(value = "resourceId", required = true) String resourceId,
            @JsonProperty(value = "name", required = true) String name,
            @JsonProperty(value = "region", required = true) String region) {
        this.id = id;
        this.resourceId = resourceId;
        this.name = name;
        this.region = region;
    }

    /**
     * Get the id property: The ID of the Log Analytics workspace.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the resourceId property: The ARM resource ID of the Log Analytics workspace.
     *
     * @return the resourceId value.
     */
    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * Get the name property: The name of the Log Analytics workspace.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the region property: The Azure region of the Log Analytics workspace.
     *
     * @return the region value.
     */
    public String getRegion() {
        return this.region;
    }

    /**
     * Get the related property: The related metadata items for the Log Analytics workspace.
     *
     * @return the related value.
     */
    public MetadataWorkspaceRelated getRelated() {
        return this.related;
    }

    /**
     * Set the related property: The related metadata items for the Log Analytics workspace.
     *
     * @param related the related value to set.
     * @return the MetadataWorkspace object itself.
     */
    public MetadataWorkspace setRelated(MetadataWorkspaceRelated related) {
        this.related = related;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getId() == null) {
            throw new IllegalArgumentException("Missing required property id in model MetadataWorkspace");
        }
        if (getResourceId() == null) {
            throw new IllegalArgumentException("Missing required property resourceId in model MetadataWorkspace");
        }
        if (getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model MetadataWorkspace");
        }
        if (getRegion() == null) {
            throw new IllegalArgumentException("Missing required property region in model MetadataWorkspace");
        }
        if (getRelated() != null) {
            getRelated().validate();
        }
    }
}
