/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.monitor.query.MetricsQueryClientBuilder;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.implementation.metrics.MonitorManagementClientImpl;
import com.azure.monitor.query.implementation.metrics.models.MetricsHelper;
import com.azure.monitor.query.implementation.metrics.models.MetricsResponse;
import com.azure.monitor.query.implementation.metrics.models.ResultType;
import com.azure.monitor.query.implementation.metricsdefinitions.MetricsDefinitionsClientImpl;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricDefinition;
import com.azure.monitor.query.implementation.metricsnamespaces.MetricsNamespacesClientImpl;
import com.azure.monitor.query.implementation.metricsnamespaces.models.MetricNamespace;
import com.azure.monitor.query.models.MetricsQueryOptions;
import com.azure.monitor.query.models.MetricsQueryResult;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=MetricsQueryClientBuilder.class)
public final class MetricsQueryClient {
    private final MonitorManagementClientImpl metricsClient;
    private final MetricsNamespacesClientImpl metricsNamespaceClient;
    private final MetricsDefinitionsClientImpl metricsDefinitionsClient;

    MetricsQueryClient(MonitorManagementClientImpl metricsClient, MetricsNamespacesClientImpl metricsNamespaceClient, MetricsDefinitionsClientImpl metricsDefinitionsClients) {
        this.metricsClient = metricsClient;
        this.metricsNamespaceClient = metricsNamespaceClient;
        this.metricsDefinitionsClient = metricsDefinitionsClients;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricsQueryResult queryResource(String resourceUri, List<String> metricsNames) {
        return (MetricsQueryResult)this.queryResourceWithResponse(resourceUri, metricsNames, new MetricsQueryOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricsQueryResult> queryResourceWithResponse(String resourceUri, List<String> metricsNames, MetricsQueryOptions options, Context context) {
        Objects.requireNonNull(resourceUri, "'resourceUri' cannot be null");
        String aggregation = null;
        if (options != null && !CoreUtils.isNullOrEmpty(options.getAggregations())) {
            aggregation = options.getAggregations().stream().map(type -> type.toString()).collect(Collectors.joining(","));
        }
        String timespan = options == null || options.getTimeInterval() == null ? null : LogsQueryHelper.toIso8601Format(options.getTimeInterval());
        Duration granularity = options == null ? null : options.getGranularity();
        Integer top = options == null ? null : options.getTop();
        String orderBy = options == null ? null : options.getOrderBy();
        String filter = options == null ? null : options.getFilter();
        String metricNamespace = options == null ? null : options.getMetricNamespace();
        Response<MetricsResponse> metricsResponseResponse = this.metricsClient.getMetrics().listWithResponse(resourceUri, timespan, granularity, String.join((CharSequence)",", metricsNames), aggregation, top, orderBy, filter, ResultType.DATA, metricNamespace, context);
        return MetricsHelper.convertToMetricsQueryResult(metricsResponseResponse);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<com.azure.monitor.query.models.MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime) {
        return this.listMetricNamespaces(resourceUri, startTime, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<com.azure.monitor.query.models.MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime, Context context) {
        Objects.requireNonNull(resourceUri, "'resourceUri' cannot be null");
        PagedResponse<MetricNamespace> response = this.metricsNamespaceClient.getMetricNamespaces().listSinglePage(resourceUri, startTime == null ? null : startTime.toString(), context);
        List metricNamespaces = response.getValue().stream().map(MetricsHelper::mapMetricNamespace).collect(Collectors.toList());
        return new PagedIterable(() -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), metricNamespaces, (String)response.getContinuationToken(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<com.azure.monitor.query.models.MetricDefinition> listMetricDefinitions(String resourceUri) {
        return this.listMetricDefinitions(resourceUri, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<com.azure.monitor.query.models.MetricDefinition> listMetricDefinitions(String resourceUri, String metricsNamespace, Context context) {
        Objects.requireNonNull(resourceUri, "'resourceUri' cannot be null");
        PagedResponse<MetricDefinition> response = this.metricsDefinitionsClient.getMetricDefinitions().listSinglePage(resourceUri, metricsNamespace, context);
        List metricDefinitions = response.getValue().stream().map(MetricsHelper::mapToMetricDefinition).collect(Collectors.toList());
        return new PagedIterable(() -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), metricDefinitions, (String)response.getContinuationToken(), null));
    }
}

