/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.query.MetricsQueryAsyncClient;
import com.azure.monitor.query.MetricsQueryClient;
import com.azure.monitor.query.MetricsQueryServiceVersion;
import com.azure.monitor.query.implementation.metrics.MonitorManagementClientImplBuilder;
import com.azure.monitor.query.implementation.metricsdefinitions.MetricsDefinitionsClientImplBuilder;
import com.azure.monitor.query.implementation.metricsnamespaces.MetricsNamespacesClientImplBuilder;

@ServiceClientBuilder(serviceClients={MetricsQueryClient.class, MetricsQueryAsyncClient.class})
public final class MetricsQueryClientBuilder
implements EndpointTrait<MetricsQueryClientBuilder>,
HttpTrait<MetricsQueryClientBuilder>,
ConfigurationTrait<MetricsQueryClientBuilder>,
TokenCredentialTrait<MetricsQueryClientBuilder> {
    private final MonitorManagementClientImplBuilder innerMetricsBuilder = new MonitorManagementClientImplBuilder();
    private final MetricsDefinitionsClientImplBuilder innerMetricsDefinitionsBuilder = new MetricsDefinitionsClientImplBuilder();
    private final MetricsNamespacesClientImplBuilder innerMetricsNamespaceBuilder = new MetricsNamespacesClientImplBuilder();
    private final ClientLogger logger = new ClientLogger(MetricsQueryClientBuilder.class);
    private MetricsQueryServiceVersion serviceVersion;

    public MetricsQueryClientBuilder endpoint(String endpoint) {
        this.innerMetricsBuilder.host(endpoint);
        this.innerMetricsDefinitionsBuilder.host(endpoint);
        this.innerMetricsNamespaceBuilder.host(endpoint);
        return this;
    }

    public MetricsQueryClientBuilder pipeline(HttpPipeline pipeline) {
        this.innerMetricsBuilder.pipeline(pipeline);
        this.innerMetricsDefinitionsBuilder.pipeline(pipeline);
        this.innerMetricsNamespaceBuilder.pipeline(pipeline);
        return this;
    }

    public MetricsQueryClientBuilder httpClient(HttpClient httpClient) {
        this.innerMetricsBuilder.httpClient(httpClient);
        this.innerMetricsDefinitionsBuilder.httpClient(httpClient);
        this.innerMetricsNamespaceBuilder.httpClient(httpClient);
        return this;
    }

    public MetricsQueryClientBuilder configuration(Configuration configuration) {
        this.innerMetricsBuilder.configuration(configuration);
        this.innerMetricsDefinitionsBuilder.configuration(configuration);
        this.innerMetricsNamespaceBuilder.configuration(configuration);
        return this;
    }

    public MetricsQueryClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.innerMetricsBuilder.httpLogOptions(httpLogOptions);
        this.innerMetricsDefinitionsBuilder.httpLogOptions(httpLogOptions);
        this.innerMetricsNamespaceBuilder.httpLogOptions(httpLogOptions);
        return this;
    }

    public MetricsQueryClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.innerMetricsBuilder.retryPolicy(retryPolicy);
        this.innerMetricsDefinitionsBuilder.retryPolicy(retryPolicy);
        this.innerMetricsNamespaceBuilder.retryPolicy(retryPolicy);
        return this;
    }

    public MetricsQueryClientBuilder retryOptions(RetryOptions retryOptions) {
        this.innerMetricsBuilder.retryOptions(retryOptions);
        this.innerMetricsDefinitionsBuilder.retryOptions(retryOptions);
        this.innerMetricsNamespaceBuilder.retryOptions(retryOptions);
        return this;
    }

    public MetricsQueryClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.innerMetricsBuilder.addPolicy(customPolicy);
        this.innerMetricsDefinitionsBuilder.addPolicy(customPolicy);
        this.innerMetricsNamespaceBuilder.addPolicy(customPolicy);
        return this;
    }

    public MetricsQueryClientBuilder credential(TokenCredential tokenCredential) {
        this.innerMetricsBuilder.credential(tokenCredential);
        this.innerMetricsDefinitionsBuilder.credential(tokenCredential);
        this.innerMetricsNamespaceBuilder.credential(tokenCredential);
        return this;
    }

    public MetricsQueryClientBuilder clientOptions(ClientOptions clientOptions) {
        this.innerMetricsBuilder.clientOptions(clientOptions);
        this.innerMetricsDefinitionsBuilder.clientOptions(clientOptions);
        this.innerMetricsNamespaceBuilder.clientOptions(clientOptions);
        return this;
    }

    public MetricsQueryClientBuilder serviceVersion(MetricsQueryServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public MetricsQueryClient buildClient() {
        return new MetricsQueryClient(this.innerMetricsBuilder.buildClient(), this.innerMetricsNamespaceBuilder.buildClient(), this.innerMetricsDefinitionsBuilder.buildClient());
    }

    public MetricsQueryAsyncClient buildAsyncClient() {
        this.logger.info("Using service version " + (Object)((Object)this.serviceVersion));
        return new MetricsQueryAsyncClient(this.innerMetricsBuilder.buildClient(), this.innerMetricsNamespaceBuilder.buildClient(), this.innerMetricsDefinitionsBuilder.buildClient());
    }
}

