// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An array of requests. */
@Immutable
public final class BatchRequest {
    /*
     * An single request in a batch.
     */
    @JsonProperty(value = "requests", required = true)
    private List<BatchQueryRequest> requests;

    /**
     * Creates an instance of BatchRequest class.
     *
     * @param requests the requests value to set.
     */
    @JsonCreator
    public BatchRequest(@JsonProperty(value = "requests", required = true) List<BatchQueryRequest> requests) {
        this.requests = requests;
    }

    /**
     * Get the requests property: An single request in a batch.
     *
     * @return the requests value.
     */
    public List<BatchQueryRequest> getRequests() {
        return this.requests;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getRequests() == null) {
            throw new IllegalArgumentException("Missing required property requests in model BatchRequest");
        } else {
            getRequests().forEach(e -> e.validate());
        }
    }
}
