// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The BatchResponseErrorInnerError model. */
@Fluent
public final class BatchResponseErrorInnerError {
    /*
     * The code property.
     */
    @JsonProperty(value = "code")
    private String code;

    /*
     * The message property.
     */
    @JsonProperty(value = "message")
    private String message;

    /*
     * The details property.
     */
    @JsonProperty(value = "details")
    private List<ErrorDetails> details;

    /**
     * Get the code property: The code property.
     *
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Set the code property: The code property.
     *
     * @param code the code value to set.
     * @return the BatchResponseErrorInnerError object itself.
     */
    public BatchResponseErrorInnerError setCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: The message property.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: The message property.
     *
     * @param message the message value to set.
     * @return the BatchResponseErrorInnerError object itself.
     */
    public BatchResponseErrorInnerError setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the details property: The details property.
     *
     * @return the details value.
     */
    public List<ErrorDetails> getDetails() {
        return this.details;
    }

    /**
     * Set the details property: The details property.
     *
     * @param details the details value to set.
     * @return the BatchResponseErrorInnerError object itself.
     */
    public BatchResponseErrorInnerError setDetails(List<ErrorDetails> details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getDetails() != null) {
            getDetails().forEach(e -> e.validate());
        }
    }
}
