// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.metrics.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

/** The response to a metrics query. */
@Fluent
public final class MetricsResponse {
    /*
     * The integer value representing the relative cost of the query.
     */
    @JsonProperty(value = "cost")
    private Integer cost;

    /*
     * The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
     * '/'.  This may be adjusted in the future and returned back from what was originally requested.
     */
    @JsonProperty(value = "timespan", required = true)
    private String timespan;

    /*
     * The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and
     * returned back from what was originally requested.  This is not present if a metadata request was made.
     */
    @JsonProperty(value = "interval")
    private Duration interval;

    /*
     * The namespace of the metrics being queried
     */
    @JsonProperty(value = "namespace")
    private String namespace;

    /*
     * The region of the resource being queried for metrics.
     */
    @JsonProperty(value = "resourceregion")
    private String resourceregion;

    /*
     * the value of the collection.
     */
    @JsonProperty(value = "value", required = true)
    private List<Metric> value;

    /**
     * Creates an instance of MetricsResponse class.
     *
     * @param timespan the timespan value to set.
     * @param value the value value to set.
     */
    @JsonCreator
    public MetricsResponse(
            @JsonProperty(value = "timespan", required = true) String timespan,
            @JsonProperty(value = "value", required = true) List<Metric> value) {
        this.timespan = timespan;
        this.value = value;
    }

    /**
     * Get the cost property: The integer value representing the relative cost of the query.
     *
     * @return the cost value.
     */
    public Integer getCost() {
        return this.cost;
    }

    /**
     * Set the cost property: The integer value representing the relative cost of the query.
     *
     * @param cost the cost value to set.
     * @return the MetricsResponse object itself.
     */
    public MetricsResponse setCost(Integer cost) {
        this.cost = cost;
        return this;
    }

    /**
     * Get the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     *
     * @return the timespan value.
     */
    public String getTimespan() {
        return this.timespan;
    }

    /**
     * Get the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     *
     * @return the interval value.
     */
    public Duration getInterval() {
        return this.interval;
    }

    /**
     * Set the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     *
     * @param interval the interval value to set.
     * @return the MetricsResponse object itself.
     */
    public MetricsResponse setInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the namespace property: The namespace of the metrics being queried.
     *
     * @return the namespace value.
     */
    public String getNamespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: The namespace of the metrics being queried.
     *
     * @param namespace the namespace value to set.
     * @return the MetricsResponse object itself.
     */
    public MetricsResponse setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the resourceregion property: The region of the resource being queried for metrics.
     *
     * @return the resourceregion value.
     */
    public String getResourceregion() {
        return this.resourceregion;
    }

    /**
     * Set the resourceregion property: The region of the resource being queried for metrics.
     *
     * @param resourceregion the resourceregion value to set.
     * @return the MetricsResponse object itself.
     */
    public MetricsResponse setResourceregion(String resourceregion) {
        this.resourceregion = resourceregion;
        return this;
    }

    /**
     * Get the value property: the value of the collection.
     *
     * @return the value value.
     */
    public List<Metric> getValue() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getTimespan() == null) {
            throw new IllegalArgumentException("Missing required property timespan in model MetricsResponse");
        }
        if (getValue() == null) {
            throw new IllegalArgumentException("Missing required property value in model MetricsResponse");
        } else {
            getValue().forEach(e -> e.validate());
        }
    }
}
