// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.metricsbatch;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.monitor.query.implementation.metricsbatch.models.BatchMetricResultsResponse;
import com.azure.monitor.query.implementation.metricsbatch.models.ErrorContractException;
import com.azure.monitor.query.implementation.metricsbatch.models.MetricBatchResourceIdList;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Metrics. */
public final class Metrics {
    /** The proxy service used to perform REST calls. */
    private final MetricsService service;

    /** The service client containing this operation class. */
    private final AzureMonitorMetricBatch client;

    /**
     * Initializes an instance of Metrics.
     *
     * @param client the instance of the service client containing this operation class.
     */
    Metrics(AzureMonitorMetricBatch client) {
        this.service = RestProxy.create(MetricsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureMonitorMetricBatchMetrics to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "AzureMonitorMetricBa")
    public interface MetricsService {
        @Post("/subscriptions/{subscriptionId}/metrics:getBatch")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorContractException.class)
        Mono<Response<BatchMetricResultsResponse>> batch(
                @HostParam("endpoint") String endpoint,
                @PathParam("subscriptionId") String subscriptionId,
                @QueryParam("starttime") String starttime,
                @QueryParam("endtime") String endtime,
                @QueryParam("interval") Duration interval,
                @QueryParam("metricnamespace") String metricnamespace,
                @QueryParam("metricnames") String metricnames,
                @QueryParam("aggregation") String aggregation,
                @QueryParam("top") Integer top,
                @QueryParam("orderby") String orderBy,
                @QueryParam("filter") String filter,
                @QueryParam("AutoAdjustTimegrain") Boolean autoAdjustTimegrain,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") MetricBatchResourceIdList resourceIds,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/subscriptions/{subscriptionId}/metrics:getBatch")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorContractException.class)
        Response<BatchMetricResultsResponse> batchSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("subscriptionId") String subscriptionId,
                @QueryParam("starttime") String starttime,
                @QueryParam("endtime") String endtime,
                @QueryParam("interval") Duration interval,
                @QueryParam("metricnamespace") String metricnamespace,
                @QueryParam("metricnames") String metricnames,
                @QueryParam("aggregation") String aggregation,
                @QueryParam("top") Integer top,
                @QueryParam("orderby") String orderBy,
                @QueryParam("filter") String filter,
                @QueryParam("AutoAdjustTimegrain") Boolean autoAdjustTimegrain,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") MetricBatchResourceIdList resourceIds,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Lists the metric values for multiple resources.
     *
     * @param subscriptionId The subscription identifier for the resources in this batch.
     * @param metricnamespace Metric namespace that contains the requested metric names.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param resourceIds The comma separated list of resource IDs to query metrics for.
     * @param starttime The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you
     *     have specified the endtime parameter, then this parameter is required. If only starttime is specified, then
     *     endtime defaults to the current time. If no time interval is specified, the default is 1 hour.
     * @param endtime The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'.
     * @param interval The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special
     *     case for 'FULL' value that returns single datapoint for entire time span requested. *Examples: PT15M, PT1H,
     *     P1D*, FULL.
     * @param aggregation The list of aggregation types (comma separated) to retrieve. *Examples: average, minimum,
     *     maximum*.
     * @param top The maximum number of records to retrieve. Valid only if a filter is specified. Defaults to 10.
     * @param orderBy The aggregation to use for sorting results and the direction of the sort. Only one order can be
     *     specified. *Examples: sum asc*.
     * @param filter The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric
     *     contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or
     *     b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid
     *     variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid
     *     because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time
     *     series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;-
     *     Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param autoAdjustTimegrain When set to true, if the timespan passed in is not supported by this metric, the API
     *     will return the result using the closest supported timespan. When set to false, an error is returned for
     *     invalid timespan parameters. Defaults to false.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorContractException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the metrics result for a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BatchMetricResultsResponse>> batchWithResponseAsync(
            String subscriptionId,
            String metricnamespace,
            List<String> metricnames,
            MetricBatchResourceIdList resourceIds,
            String starttime,
            String endtime,
            Duration interval,
            String aggregation,
            Integer top,
            String orderBy,
            String filter,
            Boolean autoAdjustTimegrain) {
        final String accept = "application/json";
        String metricnamesConverted =
                metricnames.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(
                context ->
                        service.batch(
                                this.client.getEndpoint(),
                                subscriptionId,
                                starttime,
                                endtime,
                                interval,
                                metricnamespace,
                                metricnamesConverted,
                                aggregation,
                                top,
                                orderBy,
                                filter,
                                autoAdjustTimegrain,
                                this.client.getApiVersion(),
                                resourceIds,
                                accept,
                                context));
    }

    /**
     * Lists the metric values for multiple resources.
     *
     * @param subscriptionId The subscription identifier for the resources in this batch.
     * @param metricnamespace Metric namespace that contains the requested metric names.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param resourceIds The comma separated list of resource IDs to query metrics for.
     * @param starttime The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you
     *     have specified the endtime parameter, then this parameter is required. If only starttime is specified, then
     *     endtime defaults to the current time. If no time interval is specified, the default is 1 hour.
     * @param endtime The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'.
     * @param interval The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special
     *     case for 'FULL' value that returns single datapoint for entire time span requested. *Examples: PT15M, PT1H,
     *     P1D*, FULL.
     * @param aggregation The list of aggregation types (comma separated) to retrieve. *Examples: average, minimum,
     *     maximum*.
     * @param top The maximum number of records to retrieve. Valid only if a filter is specified. Defaults to 10.
     * @param orderBy The aggregation to use for sorting results and the direction of the sort. Only one order can be
     *     specified. *Examples: sum asc*.
     * @param filter The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric
     *     contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or
     *     b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid
     *     variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid
     *     because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time
     *     series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;-
     *     Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param autoAdjustTimegrain When set to true, if the timespan passed in is not supported by this metric, the API
     *     will return the result using the closest supported timespan. When set to false, an error is returned for
     *     invalid timespan parameters. Defaults to false.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorContractException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the metrics result for a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BatchMetricResultsResponse>> batchWithResponseAsync(
            String subscriptionId,
            String metricnamespace,
            List<String> metricnames,
            MetricBatchResourceIdList resourceIds,
            String starttime,
            String endtime,
            Duration interval,
            String aggregation,
            Integer top,
            String orderBy,
            String filter,
            Boolean autoAdjustTimegrain,
            Context context) {
        final String accept = "application/json";
        String metricnamesConverted =
                metricnames.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return service.batch(
                this.client.getEndpoint(),
                subscriptionId,
                starttime,
                endtime,
                interval,
                metricnamespace,
                metricnamesConverted,
                aggregation,
                top,
                orderBy,
                filter,
                autoAdjustTimegrain,
                this.client.getApiVersion(),
                resourceIds,
                accept,
                context);
    }

    /**
     * Lists the metric values for multiple resources.
     *
     * @param subscriptionId The subscription identifier for the resources in this batch.
     * @param metricnamespace Metric namespace that contains the requested metric names.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param resourceIds The comma separated list of resource IDs to query metrics for.
     * @param starttime The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you
     *     have specified the endtime parameter, then this parameter is required. If only starttime is specified, then
     *     endtime defaults to the current time. If no time interval is specified, the default is 1 hour.
     * @param endtime The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'.
     * @param interval The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special
     *     case for 'FULL' value that returns single datapoint for entire time span requested. *Examples: PT15M, PT1H,
     *     P1D*, FULL.
     * @param aggregation The list of aggregation types (comma separated) to retrieve. *Examples: average, minimum,
     *     maximum*.
     * @param top The maximum number of records to retrieve. Valid only if a filter is specified. Defaults to 10.
     * @param orderBy The aggregation to use for sorting results and the direction of the sort. Only one order can be
     *     specified. *Examples: sum asc*.
     * @param filter The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric
     *     contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or
     *     b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid
     *     variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid
     *     because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time
     *     series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;-
     *     Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param autoAdjustTimegrain When set to true, if the timespan passed in is not supported by this metric, the API
     *     will return the result using the closest supported timespan. When set to false, an error is returned for
     *     invalid timespan parameters. Defaults to false.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorContractException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the metrics result for a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BatchMetricResultsResponse> batchAsync(
            String subscriptionId,
            String metricnamespace,
            List<String> metricnames,
            MetricBatchResourceIdList resourceIds,
            String starttime,
            String endtime,
            Duration interval,
            String aggregation,
            Integer top,
            String orderBy,
            String filter,
            Boolean autoAdjustTimegrain) {
        return batchWithResponseAsync(
                        subscriptionId,
                        metricnamespace,
                        metricnames,
                        resourceIds,
                        starttime,
                        endtime,
                        interval,
                        aggregation,
                        top,
                        orderBy,
                        filter,
                        autoAdjustTimegrain)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the metric values for multiple resources.
     *
     * @param subscriptionId The subscription identifier for the resources in this batch.
     * @param metricnamespace Metric namespace that contains the requested metric names.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param resourceIds The comma separated list of resource IDs to query metrics for.
     * @param starttime The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you
     *     have specified the endtime parameter, then this parameter is required. If only starttime is specified, then
     *     endtime defaults to the current time. If no time interval is specified, the default is 1 hour.
     * @param endtime The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'.
     * @param interval The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special
     *     case for 'FULL' value that returns single datapoint for entire time span requested. *Examples: PT15M, PT1H,
     *     P1D*, FULL.
     * @param aggregation The list of aggregation types (comma separated) to retrieve. *Examples: average, minimum,
     *     maximum*.
     * @param top The maximum number of records to retrieve. Valid only if a filter is specified. Defaults to 10.
     * @param orderBy The aggregation to use for sorting results and the direction of the sort. Only one order can be
     *     specified. *Examples: sum asc*.
     * @param filter The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric
     *     contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or
     *     b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid
     *     variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid
     *     because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time
     *     series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;-
     *     Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param autoAdjustTimegrain When set to true, if the timespan passed in is not supported by this metric, the API
     *     will return the result using the closest supported timespan. When set to false, an error is returned for
     *     invalid timespan parameters. Defaults to false.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorContractException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the metrics result for a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BatchMetricResultsResponse> batchAsync(
            String subscriptionId,
            String metricnamespace,
            List<String> metricnames,
            MetricBatchResourceIdList resourceIds,
            String starttime,
            String endtime,
            Duration interval,
            String aggregation,
            Integer top,
            String orderBy,
            String filter,
            Boolean autoAdjustTimegrain,
            Context context) {
        return batchWithResponseAsync(
                        subscriptionId,
                        metricnamespace,
                        metricnames,
                        resourceIds,
                        starttime,
                        endtime,
                        interval,
                        aggregation,
                        top,
                        orderBy,
                        filter,
                        autoAdjustTimegrain,
                        context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the metric values for multiple resources.
     *
     * @param subscriptionId The subscription identifier for the resources in this batch.
     * @param metricnamespace Metric namespace that contains the requested metric names.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param resourceIds The comma separated list of resource IDs to query metrics for.
     * @param starttime The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you
     *     have specified the endtime parameter, then this parameter is required. If only starttime is specified, then
     *     endtime defaults to the current time. If no time interval is specified, the default is 1 hour.
     * @param endtime The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'.
     * @param interval The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special
     *     case for 'FULL' value that returns single datapoint for entire time span requested. *Examples: PT15M, PT1H,
     *     P1D*, FULL.
     * @param aggregation The list of aggregation types (comma separated) to retrieve. *Examples: average, minimum,
     *     maximum*.
     * @param top The maximum number of records to retrieve. Valid only if a filter is specified. Defaults to 10.
     * @param orderBy The aggregation to use for sorting results and the direction of the sort. Only one order can be
     *     specified. *Examples: sum asc*.
     * @param filter The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric
     *     contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or
     *     b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid
     *     variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid
     *     because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time
     *     series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;-
     *     Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param autoAdjustTimegrain When set to true, if the timespan passed in is not supported by this metric, the API
     *     will return the result using the closest supported timespan. When set to false, an error is returned for
     *     invalid timespan parameters. Defaults to false.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorContractException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the metrics result for a resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BatchMetricResultsResponse> batchWithResponse(
            String subscriptionId,
            String metricnamespace,
            List<String> metricnames,
            MetricBatchResourceIdList resourceIds,
            String starttime,
            String endtime,
            Duration interval,
            String aggregation,
            Integer top,
            String orderBy,
            String filter,
            Boolean autoAdjustTimegrain,
            Context context) {
        final String accept = "application/json";
        String metricnamesConverted =
                metricnames.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return service.batchSync(
                this.client.getEndpoint(),
                subscriptionId,
                starttime,
                endtime,
                interval,
                metricnamespace,
                metricnamesConverted,
                aggregation,
                top,
                orderBy,
                filter,
                autoAdjustTimegrain,
                this.client.getApiVersion(),
                resourceIds,
                accept,
                context);
    }

    /**
     * Lists the metric values for multiple resources.
     *
     * @param subscriptionId The subscription identifier for the resources in this batch.
     * @param metricnamespace Metric namespace that contains the requested metric names.
     * @param metricnames The names of the metrics (comma separated) to retrieve.
     * @param resourceIds The comma separated list of resource IDs to query metrics for.
     * @param starttime The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you
     *     have specified the endtime parameter, then this parameter is required. If only starttime is specified, then
     *     endtime defaults to the current time. If no time interval is specified, the default is 1 hour.
     * @param endtime The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'.
     * @param interval The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special
     *     case for 'FULL' value that returns single datapoint for entire time span requested. *Examples: PT15M, PT1H,
     *     P1D*, FULL.
     * @param aggregation The list of aggregation types (comma separated) to retrieve. *Examples: average, minimum,
     *     maximum*.
     * @param top The maximum number of records to retrieve. Valid only if a filter is specified. Defaults to 10.
     * @param orderBy The aggregation to use for sorting results and the direction of the sort. Only one order can be
     *     specified. *Examples: sum asc*.
     * @param filter The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric
     *     contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or
     *     b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid
     *     variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid
     *     because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time
     *     series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;-
     *     Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
     * @param autoAdjustTimegrain When set to true, if the timespan passed in is not supported by this metric, the API
     *     will return the result using the closest supported timespan. When set to false, an error is returned for
     *     invalid timespan parameters. Defaults to false.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorContractException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the metrics result for a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BatchMetricResultsResponse batch(
            String subscriptionId,
            String metricnamespace,
            List<String> metricnames,
            MetricBatchResourceIdList resourceIds,
            String starttime,
            String endtime,
            Duration interval,
            String aggregation,
            Integer top,
            String orderBy,
            String filter,
            Boolean autoAdjustTimegrain) {
        return batchWithResponse(
                        subscriptionId,
                        metricnamespace,
                        metricnames,
                        resourceIds,
                        starttime,
                        endtime,
                        interval,
                        aggregation,
                        top,
                        orderBy,
                        filter,
                        autoAdjustTimegrain,
                        Context.NONE)
                .getValue();
    }
}
