// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.metricsbatch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

/** The BatchMetricResultsResponseValuesItem model. */
@Fluent
public final class BatchMetricResultsResponseValuesItem {
    /*
     * The start time, in datetime format, for which the data was retrieved.
     */
    @JsonProperty(value = "starttime", required = true)
    private String starttime;

    /*
     * The end time, in datetime format, for which the data was retrieved.
     */
    @JsonProperty(value = "endtime", required = true)
    private String endtime;

    /*
     * The interval (window size) for which the metric data was returned in. Follows the IS8601/RFC3339 duration format
     * (e.g. 'P1D' for 1 day). This may be adjusted in the future and returned back from what was originally requested.
     * This is not present if a metadata request was made.
     */
    @JsonProperty(value = "interval")
    private Duration interval;

    /*
     * The namespace of the metrics been queried
     */
    @JsonProperty(value = "namespace")
    private String namespace;

    /*
     * The region of the resource been queried for metrics.
     */
    @JsonProperty(value = "resourceregion")
    private String resourceregion;

    /*
     * The resource that has been queried for metrics.
     */
    @JsonProperty(value = "resourceid")
    private String resourceid;

    /*
     * The value of the collection.
     */
    @JsonProperty(value = "value", required = true)
    private List<SubscriptionScopeMetric> value;

    /**
     * Creates an instance of BatchMetricResultsResponseValuesItem class.
     *
     * @param starttime the starttime value to set.
     * @param endtime the endtime value to set.
     * @param value the value value to set.
     */
    @JsonCreator
    public BatchMetricResultsResponseValuesItem(
            @JsonProperty(value = "starttime", required = true) String starttime,
            @JsonProperty(value = "endtime", required = true) String endtime,
            @JsonProperty(value = "value", required = true) List<SubscriptionScopeMetric> value) {
        this.starttime = starttime;
        this.endtime = endtime;
        this.value = value;
    }

    /**
     * Get the starttime property: The start time, in datetime format, for which the data was retrieved.
     *
     * @return the starttime value.
     */
    public String getStarttime() {
        return this.starttime;
    }

    /**
     * Get the endtime property: The end time, in datetime format, for which the data was retrieved.
     *
     * @return the endtime value.
     */
    public String getEndtime() {
        return this.endtime;
    }

    /**
     * Get the interval property: The interval (window size) for which the metric data was returned in. Follows the
     * IS8601/RFC3339 duration format (e.g. 'P1D' for 1 day). This may be adjusted in the future and returned back from
     * what was originally requested. This is not present if a metadata request was made.
     *
     * @return the interval value.
     */
    public Duration getInterval() {
        return this.interval;
    }

    /**
     * Set the interval property: The interval (window size) for which the metric data was returned in. Follows the
     * IS8601/RFC3339 duration format (e.g. 'P1D' for 1 day). This may be adjusted in the future and returned back from
     * what was originally requested. This is not present if a metadata request was made.
     *
     * @param interval the interval value to set.
     * @return the BatchMetricResultsResponseValuesItem object itself.
     */
    public BatchMetricResultsResponseValuesItem setInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the namespace property: The namespace of the metrics been queried.
     *
     * @return the namespace value.
     */
    public String getNamespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: The namespace of the metrics been queried.
     *
     * @param namespace the namespace value to set.
     * @return the BatchMetricResultsResponseValuesItem object itself.
     */
    public BatchMetricResultsResponseValuesItem setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the resourceregion property: The region of the resource been queried for metrics.
     *
     * @return the resourceregion value.
     */
    public String getResourceregion() {
        return this.resourceregion;
    }

    /**
     * Set the resourceregion property: The region of the resource been queried for metrics.
     *
     * @param resourceregion the resourceregion value to set.
     * @return the BatchMetricResultsResponseValuesItem object itself.
     */
    public BatchMetricResultsResponseValuesItem setResourceregion(String resourceregion) {
        this.resourceregion = resourceregion;
        return this;
    }

    /**
     * Get the resourceid property: The resource that has been queried for metrics.
     *
     * @return the resourceid value.
     */
    public String getResourceid() {
        return this.resourceid;
    }

    /**
     * Set the resourceid property: The resource that has been queried for metrics.
     *
     * @param resourceid the resourceid value to set.
     * @return the BatchMetricResultsResponseValuesItem object itself.
     */
    public BatchMetricResultsResponseValuesItem setResourceid(String resourceid) {
        this.resourceid = resourceid;
        return this;
    }

    /**
     * Get the value property: The value of the collection.
     *
     * @return the value value.
     */
    public List<SubscriptionScopeMetric> getValue() {
        return this.value;
    }
}
