// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.metricsbatch.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The localizable string class. */
@Fluent
public final class LocalizableString {
    /*
     * The invariant value.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /*
     * The display name.
     */
    @JsonProperty(value = "localizedValue")
    private String localizedValue;

    /**
     * Creates an instance of LocalizableString class.
     *
     * @param value the value value to set.
     */
    @JsonCreator
    public LocalizableString(@JsonProperty(value = "value", required = true) String value) {
        this.value = value;
    }

    /**
     * Get the value property: The invariant value.
     *
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Get the localizedValue property: The display name.
     *
     * @return the localizedValue value.
     */
    public String getLocalizedValue() {
        return this.localizedValue;
    }

    /**
     * Set the localizedValue property: The display name.
     *
     * @param localizedValue the localizedValue value to set.
     * @return the LocalizableString object itself.
     */
    public LocalizableString setLocalizedValue(String localizedValue) {
        this.localizedValue = localizedValue;
        return this;
    }
}
