/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.monitor.query.LogsQueryClientBuilder;
import com.azure.monitor.query.implementation.logs.AzureLogAnalyticsImpl;
import com.azure.monitor.query.implementation.logs.models.BatchQueryRequest;
import com.azure.monitor.query.implementation.logs.models.BatchRequest;
import com.azure.monitor.query.implementation.logs.models.BatchResponse;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.implementation.logs.models.QueryBody;
import com.azure.monitor.query.implementation.logs.models.QueryResults;
import com.azure.monitor.query.models.LogsBatchQuery;
import com.azure.monitor.query.models.LogsBatchQueryResultCollection;
import com.azure.monitor.query.models.LogsQueryOptions;
import com.azure.monitor.query.models.LogsQueryResult;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

@ServiceClient(builder=LogsQueryClientBuilder.class)
public final class LogsQueryClient {
    private final AzureLogAnalyticsImpl serviceClient;

    LogsQueryClient(AzureLogAnalyticsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogsQueryResult queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval) {
        return (LogsQueryResult)this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, new LogsQueryOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> List<T> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type) {
        LogsQueryResult logsQueryResult = (LogsQueryResult)this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, new LogsQueryOptions(), Context.NONE).getValue();
        if (logsQueryResult != null) {
            return LogsQueryHelper.toObject(logsQueryResult.getTable(), type);
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> List<T> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        LogsQueryResult logsQueryResult = (LogsQueryResult)this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, Context.NONE).getValue();
        if (logsQueryResult != null) {
            return LogsQueryHelper.toObject(logsQueryResult.getTable(), type);
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogsQueryResult> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        return this.queryWorkspaceWithResponseInternal(workspaceId, query, timeInterval, options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Response<List<T>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options, Context context) {
        Response<LogsQueryResult> response = this.queryWorkspaceWithResponseInternal(workspaceId, query, timeInterval, options, context);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type));
    }

    Response<LogsQueryResult> queryWorkspaceWithResponseInternal(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        Objects.requireNonNull(workspaceId, "'workspaceId' cannot be null.");
        Objects.requireNonNull(query, "'query' cannot be null.");
        String preferHeader = LogsQueryHelper.buildPreferHeaderString(options);
        context = LogsQueryHelper.updateContext(options.getServerTimeout(), context);
        QueryBody queryBody = new QueryBody(query);
        if (timeInterval != null) {
            queryBody.setTimespan(LogsQueryHelper.toIso8601Format(timeInterval));
        }
        queryBody.setWorkspaces(LogsQueryHelper.getAllWorkspaces(options));
        Response<QueryResults> queryResultsResponse = this.serviceClient.getQueries().executeWithResponse(workspaceId, queryBody, preferHeader, context);
        return LogsQueryHelper.convertToLogQueryResult(queryResultsResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogsBatchQueryResultCollection queryBatch(LogsBatchQuery logsBatchQuery) {
        return (LogsBatchQueryResultCollection)this.queryBatchWithResponse(logsBatchQuery, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogsBatchQueryResultCollection> queryBatchWithResponse(LogsBatchQuery logsBatchQuery, Context context) {
        return this.queryBatchWithResponseInternal(logsBatchQuery, context);
    }

    private Response<LogsBatchQueryResultCollection> queryBatchWithResponseInternal(LogsBatchQuery logsBatchQuery, Context context) {
        Objects.requireNonNull(logsBatchQuery, "'logsBatchQuery' cannot be null.");
        List<BatchQueryRequest> requests = LogsQueryHelper.getBatchQueries(logsBatchQuery);
        Duration maxServerTimeout = LogsQueryHelper.getMaxServerTimeout(logsBatchQuery);
        if (maxServerTimeout != null) {
            context = context.addData((Object)"azure-response-timeout", (Object)maxServerTimeout.plusSeconds(5L));
        }
        BatchRequest batchRequest = new BatchRequest(requests);
        Response<BatchResponse> batchResponseResponse = this.serviceClient.getQueries().batchWithResponse(batchRequest, context);
        return LogsQueryHelper.convertToLogQueryBatchResult(batchResponseResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogsQueryResult queryResource(String resourceId, String query, QueryTimeInterval timeInterval) {
        return (LogsQueryResult)this.queryResourceWithResponse(resourceId, query, timeInterval, new LogsQueryOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> List<T> queryResource(String resourceId, String query, QueryTimeInterval timeInterval, Class<T> type) {
        LogsQueryResult logsQueryResult = this.queryResource(resourceId, query, timeInterval);
        if (logsQueryResult != null) {
            return LogsQueryHelper.toObject(logsQueryResult.getTable(), type);
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> List<T> queryResource(String resourceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        LogsQueryResult logsQueryResult = (LogsQueryResult)this.queryResourceWithResponse(resourceId, query, timeInterval, options, Context.NONE).getValue();
        if (logsQueryResult != null) {
            return LogsQueryHelper.toObject(logsQueryResult.getTable(), type);
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogsQueryResult> queryResourceWithResponse(String resourceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        return this.queryResourceWithResponseInternal(resourceId, query, timeInterval, options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Response<List<T>> queryResourceWithResponse(String resourceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options, Context context) {
        Response<LogsQueryResult> response = this.queryResourceWithResponseInternal(resourceId, query, timeInterval, options, context);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type));
    }

    private Response<LogsQueryResult> queryResourceWithResponseInternal(String resourceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        Objects.requireNonNull(resourceId, "'resourceId' cannot be null.");
        Objects.requireNonNull(query, "'query' cannot be null.");
        if (resourceId.startsWith("/")) {
            resourceId = resourceId.substring(1);
        }
        String preferHeader = LogsQueryHelper.buildPreferHeaderString(options);
        context = LogsQueryHelper.updateContext(options.getServerTimeout(), context);
        QueryBody queryBody = new QueryBody(query);
        if (timeInterval != null) {
            queryBody.setTimespan(LogsQueryHelper.toIso8601Format(timeInterval));
        }
        queryBody.setWorkspaces(LogsQueryHelper.getAllWorkspaces(options));
        Response<QueryResults> queryResultsResponse = this.serviceClient.getQueries().resourceExecuteWithResponse(resourceId, queryBody, preferHeader, context);
        return LogsQueryHelper.convertToLogQueryResult(queryResultsResponse);
    }
}

