/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.query.MetricsBatchQueryClientBuilder;
import com.azure.monitor.query.implementation.metrics.models.MetricsHelper;
import com.azure.monitor.query.implementation.metricsbatch.AzureMonitorMetricBatch;
import com.azure.monitor.query.implementation.metricsbatch.models.BatchMetricResultsResponse;
import com.azure.monitor.query.implementation.metricsbatch.models.BatchMetricResultsResponseValuesItem;
import com.azure.monitor.query.implementation.metricsbatch.models.MetricBatchResourceIdList;
import com.azure.monitor.query.models.AggregationType;
import com.azure.monitor.query.models.MetricsBatchResult;
import com.azure.monitor.query.models.MetricsQueryOptions;
import com.azure.monitor.query.models.MetricsQueryResult;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MetricsBatchQueryClientBuilder.class, isAsync=true)
public final class MetricsBatchQueryAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(MetricsBatchQueryAsyncClient.class);
    private final AzureMonitorMetricBatch serviceClient;

    MetricsBatchQueryAsyncClient(AzureMonitorMetricBatch azureMonitorMetricBatch) {
        this.serviceClient = azureMonitorMetricBatch;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsBatchResult> queryBatch(List<String> resourceUris, List<String> metricsNames, String metricsNamespace) {
        return this.queryBatchWithResponse(resourceUris, metricsNames, metricsNamespace, new MetricsQueryOptions()).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsBatchResult>> queryBatchWithResponse(List<String> resourceUris, List<String> metricsNames, String metricsNamespace, MetricsQueryOptions options) {
        if (CoreUtils.isNullOrEmpty((Collection)Objects.requireNonNull(resourceUris, "'resourceUris cannot be null."))) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("resourceUris cannot be empty"));
        }
        if (CoreUtils.isNullOrEmpty((Collection)Objects.requireNonNull(metricsNames, "metricsNames cannot be null"))) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("metricsNames cannot be empty"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)Objects.requireNonNull(metricsNamespace, "metricsNamespace cannot be null"))) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("metricsNamespace cannot be empty"));
        }
        String filter = null;
        Duration granularity = null;
        String aggregations = null;
        String startTime = null;
        Integer top = null;
        String orderBy = null;
        String endTime = null;
        if (options != null) {
            filter = options.getFilter();
            granularity = options.getGranularity();
            if (options.getAggregations() != null) {
                aggregations = options.getAggregations().stream().map(AggregationType::toString).collect(Collectors.joining(","));
            }
            if (options.getTimeInterval() != null) {
                if (options.getTimeInterval().getDuration() != null) {
                    return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Duration is not a supported time interval for batch query. Use startTime and endTime instead."));
                }
                if (options.getTimeInterval().getStartTime() != null) {
                    startTime = options.getTimeInterval().getStartTime().toString();
                }
                if (options.getTimeInterval().getEndTime() != null) {
                    endTime = options.getTimeInterval().getEndTime().toString();
                }
            }
            top = options.getTop();
            orderBy = options.getOrderBy();
        }
        String subscriptionId = MetricsHelper.getSubscriptionFromResourceId(resourceUris.get(0));
        MetricBatchResourceIdList resourceIdList = new MetricBatchResourceIdList();
        resourceIdList.setResourceids(resourceUris);
        Mono<Response<BatchMetricResultsResponse>> responseMono = this.serviceClient.getMetrics().batchWithResponseAsync(subscriptionId, metricsNamespace, metricsNames, resourceIdList, startTime, endTime, granularity, aggregations, top, orderBy, filter, null);
        return responseMono.map(response -> {
            BatchMetricResultsResponse value = (BatchMetricResultsResponse)response.getValue();
            List<BatchMetricResultsResponseValuesItem> values = value.getValues();
            List<MetricsQueryResult> metricsQueryResults = values.stream().map(result -> MetricsHelper.mapToMetricsQueryResult(result)).collect(Collectors.toList());
            MetricsBatchResult metricsBatchResult = new MetricsBatchResult(metricsQueryResults);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)metricsBatchResult);
        });
    }
}

