/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.monitor.query.MetricsBatchQueryAsyncClient;
import com.azure.monitor.query.MetricsBatchQueryClient;
import com.azure.monitor.query.MetricsBatchQueryServiceVersion;
import com.azure.monitor.query.implementation.metricsbatch.AzureMonitorMetricBatchBuilder;

@ServiceClientBuilder(serviceClients={MetricsBatchQueryClient.class, MetricsBatchQueryAsyncClient.class})
public final class MetricsBatchQueryClientBuilder
implements EndpointTrait<MetricsBatchQueryClientBuilder>,
HttpTrait<MetricsBatchQueryClientBuilder>,
ConfigurationTrait<MetricsBatchQueryClientBuilder>,
TokenCredentialTrait<MetricsBatchQueryClientBuilder> {
    private final AzureMonitorMetricBatchBuilder innerMetricsBatchBuilder = new AzureMonitorMetricBatchBuilder();

    public MetricsBatchQueryClientBuilder endpoint(String endpoint) {
        this.innerMetricsBatchBuilder.endpoint(endpoint);
        return this;
    }

    public MetricsBatchQueryClientBuilder pipeline(HttpPipeline pipeline) {
        this.innerMetricsBatchBuilder.pipeline(pipeline);
        return this;
    }

    public MetricsBatchQueryClientBuilder httpClient(HttpClient httpClient) {
        this.innerMetricsBatchBuilder.httpClient(httpClient);
        return this;
    }

    public MetricsBatchQueryClientBuilder configuration(Configuration configuration) {
        this.innerMetricsBatchBuilder.configuration(configuration);
        return this;
    }

    public MetricsBatchQueryClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.innerMetricsBatchBuilder.httpLogOptions(httpLogOptions);
        return this;
    }

    public MetricsBatchQueryClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.innerMetricsBatchBuilder.retryPolicy(retryPolicy);
        return this;
    }

    public MetricsBatchQueryClientBuilder retryOptions(RetryOptions retryOptions) {
        this.innerMetricsBatchBuilder.retryOptions(retryOptions);
        return this;
    }

    public MetricsBatchQueryClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.innerMetricsBatchBuilder.addPolicy(customPolicy);
        return this;
    }

    public MetricsBatchQueryClientBuilder credential(TokenCredential tokenCredential) {
        this.innerMetricsBatchBuilder.credential(tokenCredential);
        return this;
    }

    public MetricsBatchQueryClientBuilder clientOptions(ClientOptions clientOptions) {
        this.innerMetricsBatchBuilder.clientOptions(clientOptions);
        return this;
    }

    public MetricsBatchQueryClientBuilder serviceVersion(MetricsBatchQueryServiceVersion serviceVersion) {
        this.innerMetricsBatchBuilder.apiVersion(serviceVersion.getVersion());
        return this;
    }

    public MetricsBatchQueryClient buildClient() {
        return new MetricsBatchQueryClient(this.innerMetricsBatchBuilder.buildClient());
    }

    public MetricsBatchQueryAsyncClient buildAsyncClient() {
        return new MetricsBatchQueryAsyncClient(this.innerMetricsBatchBuilder.buildClient());
    }
}

