/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsbatch;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.metricsbatch.AzureMonitorMetricBatch;
import com.azure.monitor.query.implementation.metricsbatch.models.BatchMetricResultsResponse;
import com.azure.monitor.query.implementation.metricsbatch.models.ErrorContractException;
import com.azure.monitor.query.implementation.metricsbatch.models.MetricBatchResourceIdList;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class Metrics {
    private final MetricsService service;
    private final AzureMonitorMetricBatch client;

    Metrics(AzureMonitorMetricBatch client) {
        this.service = (MetricsService)RestProxy.create(MetricsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BatchMetricResultsResponse>> batchWithResponseAsync(String subscriptionId, String metricnamespace, List<String> metricnames, MetricBatchResourceIdList resourceIds, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, Boolean autoAdjustTimegrain) {
        String accept = "application/json";
        String metricnamesConverted = metricnames.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.batch(this.client.getEndpoint(), subscriptionId, starttime, endtime, interval, metricnamespace, metricnamesConverted, aggregation, top, orderBy, filter, autoAdjustTimegrain, this.client.getApiVersion(), resourceIds, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BatchMetricResultsResponse>> batchWithResponseAsync(String subscriptionId, String metricnamespace, List<String> metricnames, MetricBatchResourceIdList resourceIds, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, Boolean autoAdjustTimegrain, Context context) {
        String accept = "application/json";
        String metricnamesConverted = metricnames.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.batch(this.client.getEndpoint(), subscriptionId, starttime, endtime, interval, metricnamespace, metricnamesConverted, aggregation, top, orderBy, filter, autoAdjustTimegrain, this.client.getApiVersion(), resourceIds, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchMetricResultsResponse> batchAsync(String subscriptionId, String metricnamespace, List<String> metricnames, MetricBatchResourceIdList resourceIds, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, Boolean autoAdjustTimegrain) {
        return this.batchWithResponseAsync(subscriptionId, metricnamespace, metricnames, resourceIds, starttime, endtime, interval, aggregation, top, orderBy, filter, autoAdjustTimegrain).flatMap(res -> Mono.justOrEmpty((Object)((BatchMetricResultsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchMetricResultsResponse> batchAsync(String subscriptionId, String metricnamespace, List<String> metricnames, MetricBatchResourceIdList resourceIds, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, Boolean autoAdjustTimegrain, Context context) {
        return this.batchWithResponseAsync(subscriptionId, metricnamespace, metricnames, resourceIds, starttime, endtime, interval, aggregation, top, orderBy, filter, autoAdjustTimegrain, context).flatMap(res -> Mono.justOrEmpty((Object)((BatchMetricResultsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BatchMetricResultsResponse> batchWithResponse(String subscriptionId, String metricnamespace, List<String> metricnames, MetricBatchResourceIdList resourceIds, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, Boolean autoAdjustTimegrain, Context context) {
        String accept = "application/json";
        String metricnamesConverted = metricnames.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.batchSync(this.client.getEndpoint(), subscriptionId, starttime, endtime, interval, metricnamespace, metricnamesConverted, aggregation, top, orderBy, filter, autoAdjustTimegrain, this.client.getApiVersion(), resourceIds, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BatchMetricResultsResponse batch(String subscriptionId, String metricnamespace, List<String> metricnames, MetricBatchResourceIdList resourceIds, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, Boolean autoAdjustTimegrain) {
        return (BatchMetricResultsResponse)this.batchWithResponse(subscriptionId, metricnamespace, metricnames, resourceIds, starttime, endtime, interval, aggregation, top, orderBy, filter, autoAdjustTimegrain, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureMonitorMetricBa")
    public static interface MetricsService {
        @Post(value="/subscriptions/{subscriptionId}/metrics:getBatch")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<BatchMetricResultsResponse>> batch(@HostParam(value="endpoint") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="starttime") String var3, @QueryParam(value="endtime") String var4, @QueryParam(value="interval") Duration var5, @QueryParam(value="metricnamespace") String var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="filter") String var11, @QueryParam(value="AutoAdjustTimegrain") Boolean var12, @QueryParam(value="api-version") String var13, @BodyParam(value="application/json") MetricBatchResourceIdList var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Post(value="/subscriptions/{subscriptionId}/metrics:getBatch")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Response<BatchMetricResultsResponse> batchSync(@HostParam(value="endpoint") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="starttime") String var3, @QueryParam(value="endtime") String var4, @QueryParam(value="interval") Duration var5, @QueryParam(value="metricnamespace") String var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="filter") String var11, @QueryParam(value="AutoAdjustTimegrain") Boolean var12, @QueryParam(value="api-version") String var13, @BodyParam(value="application/json") MetricBatchResourceIdList var14, @HeaderParam(value="Accept") String var15, Context var16);
    }
}

