/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.LogsColumnType;
import java.io.IOException;

public final class Column
implements JsonSerializable<Column> {
    private String name;
    private LogsColumnType type;

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public LogsColumnType getType() {
        return this.type;
    }

    public Column setType(LogsColumnType type) {
        this.type = type;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static Column fromJson(JsonReader jsonReader) throws IOException {
        return (Column)jsonReader.readObject(reader -> {
            Column deserializedColumn = new Column();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedColumn.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedColumn.type = LogsColumnType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedColumn;
        });
    }
}

