/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataCategoryRelated;
import java.io.IOException;
import java.util.ArrayList;

public final class MetadataCategory
implements JsonSerializable<MetadataCategory> {
    private final String id;
    private final String displayName;
    private String description;
    private MetadataCategoryRelated related;

    public MetadataCategory(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataCategory setDescription(String description) {
        this.description = description;
        return this;
    }

    public MetadataCategoryRelated getRelated() {
        return this.related;
    }

    public MetadataCategory setRelated(MetadataCategoryRelated related) {
        this.related = related;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        return jsonWriter.writeEndObject();
    }

    public static MetadataCategory fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataCategory)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean displayNameFound = false;
            String displayName = null;
            String description = null;
            MetadataCategoryRelated related = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    displayNameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("related".equals(fieldName)) {
                    related = MetadataCategoryRelated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && displayNameFound) {
                MetadataCategory deserializedMetadataCategory = new MetadataCategory(id, displayName);
                deserializedMetadataCategory.description = description;
                deserializedMetadataCategory.related = related;
                return deserializedMetadataCategory;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!displayNameFound) {
                missingProperties.add("displayName");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

