/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataPermissionsApplicationsItem;
import com.azure.monitor.query.implementation.logs.models.MetadataPermissionsResourcesItem;
import com.azure.monitor.query.implementation.logs.models.MetadataPermissionsWorkspacesItem;
import java.io.IOException;
import java.util.List;

public final class MetadataPermissions
implements JsonSerializable<MetadataPermissions> {
    private final List<MetadataPermissionsWorkspacesItem> workspaces;
    private List<MetadataPermissionsResourcesItem> resources;
    private List<MetadataPermissionsApplicationsItem> applications;

    public MetadataPermissions(List<MetadataPermissionsWorkspacesItem> workspaces) {
        this.workspaces = workspaces;
    }

    public List<MetadataPermissionsWorkspacesItem> getWorkspaces() {
        return this.workspaces;
    }

    public List<MetadataPermissionsResourcesItem> getResources() {
        return this.resources;
    }

    public MetadataPermissions setResources(List<MetadataPermissionsResourcesItem> resources) {
        this.resources = resources;
        return this;
    }

    public List<MetadataPermissionsApplicationsItem> getApplications() {
        return this.applications;
    }

    public MetadataPermissions setApplications(List<MetadataPermissionsApplicationsItem> applications) {
        this.applications = applications;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("workspaces", this.workspaces, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applications", this.applications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetadataPermissions fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataPermissions)jsonReader.readObject(reader -> {
            boolean workspacesFound = false;
            List workspaces = null;
            List resources = null;
            List applications = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workspaces".equals(fieldName)) {
                    workspaces = reader.readArray(reader1 -> MetadataPermissionsWorkspacesItem.fromJson(reader1));
                    workspacesFound = true;
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    resources = reader.readArray(reader1 -> MetadataPermissionsResourcesItem.fromJson(reader1));
                    continue;
                }
                if ("applications".equals(fieldName)) {
                    applications = reader.readArray(reader1 -> MetadataPermissionsApplicationsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (workspacesFound) {
                MetadataPermissions deserializedMetadataPermissions = new MetadataPermissions(workspaces);
                deserializedMetadataPermissions.resources = resources;
                deserializedMetadataPermissions.applications = applications;
                return deserializedMetadataPermissions;
            }
            throw new IllegalStateException("Missing required property: workspaces");
        });
    }
}

