/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataTableColumnsItem;
import com.azure.monitor.query.implementation.logs.models.MetadataTableRelated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MetadataTable
implements JsonSerializable<MetadataTable> {
    private final String id;
    private final String name;
    private String description;
    private String timespanColumn;
    private List<String> labels;
    private Object tags;
    private Object properties;
    private List<MetadataTableColumnsItem> columns;
    private MetadataTableRelated related;

    public MetadataTable(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataTable setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getTimespanColumn() {
        return this.timespanColumn;
    }

    public MetadataTable setTimespanColumn(String timespanColumn) {
        this.timespanColumn = timespanColumn;
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public MetadataTable setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public Object getTags() {
        return this.tags;
    }

    public MetadataTable setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    public Object getProperties() {
        return this.properties;
    }

    public MetadataTable setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public List<MetadataTableColumnsItem> getColumns() {
        return this.columns;
    }

    public MetadataTable setColumns(List<MetadataTableColumnsItem> columns) {
        this.columns = columns;
        return this;
    }

    public MetadataTableRelated getRelated() {
        return this.related;
    }

    public MetadataTable setRelated(MetadataTableRelated related) {
        this.related = related;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("timespanColumn", this.timespanColumn);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeUntypedField("tags", this.tags);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        return jsonWriter.writeEndObject();
    }

    public static MetadataTable fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataTable)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean nameFound = false;
            String name = null;
            String description = null;
            String timespanColumn = null;
            List labels = null;
            Object tags = null;
            Object properties = null;
            List columns = null;
            MetadataTableRelated related = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("timespanColumn".equals(fieldName)) {
                    timespanColumn = reader.getString();
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readUntyped();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readUntyped();
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    columns = reader.readArray(reader1 -> MetadataTableColumnsItem.fromJson(reader1));
                    continue;
                }
                if ("related".equals(fieldName)) {
                    related = MetadataTableRelated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && nameFound) {
                MetadataTable deserializedMetadataTable = new MetadataTable(id, name);
                deserializedMetadataTable.description = description;
                deserializedMetadataTable.timespanColumn = timespanColumn;
                deserializedMetadataTable.labels = labels;
                deserializedMetadataTable.tags = tags;
                deserializedMetadataTable.properties = properties;
                deserializedMetadataTable.columns = columns;
                deserializedMetadataTable.related = related;
                return deserializedMetadataTable;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

