/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsbatch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LocalizableString
implements JsonSerializable<LocalizableString> {
    private final String value;
    private String localizedValue;

    public LocalizableString(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getLocalizedValue() {
        return this.localizedValue;
    }

    public LocalizableString setLocalizedValue(String localizedValue) {
        this.localizedValue = localizedValue;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("localizedValue", this.localizedValue);
        return jsonWriter.writeEndObject();
    }

    public static LocalizableString fromJson(JsonReader jsonReader) throws IOException {
        return (LocalizableString)jsonReader.readObject(reader -> {
            boolean valueFound = false;
            String value = null;
            String localizedValue = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    value = reader.getString();
                    valueFound = true;
                    continue;
                }
                if ("localizedValue".equals(fieldName)) {
                    localizedValue = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (valueFound) {
                LocalizableString deserializedLocalizableString = new LocalizableString(value);
                deserializedLocalizableString.localizedValue = localizedValue;
                return deserializedLocalizableString;
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

