/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsdefinitions.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.metricsdefinitions.models.LocalizableString;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricAggregationType;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricAvailability;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricClass;
import com.azure.monitor.query.implementation.metricsdefinitions.models.MetricUnit;
import java.io.IOException;
import java.util.List;

public final class SubscriptionScopeMetricDefinition
implements JsonSerializable<SubscriptionScopeMetricDefinition> {
    private Boolean isDimensionRequired;
    private String resourceId;
    private String namespace;
    private LocalizableString name;
    private String displayDescription;
    private String category;
    private MetricClass metricClass;
    private MetricUnit unit;
    private MetricAggregationType primaryAggregationType;
    private List<MetricAggregationType> supportedAggregationTypes;
    private List<MetricAvailability> metricAvailabilities;
    private String id;
    private List<LocalizableString> dimensions;

    public Boolean isDimensionRequired() {
        return this.isDimensionRequired;
    }

    public SubscriptionScopeMetricDefinition setIsDimensionRequired(Boolean isDimensionRequired) {
        this.isDimensionRequired = isDimensionRequired;
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public SubscriptionScopeMetricDefinition setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public SubscriptionScopeMetricDefinition setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public LocalizableString getName() {
        return this.name;
    }

    public SubscriptionScopeMetricDefinition setName(LocalizableString name) {
        this.name = name;
        return this;
    }

    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public SubscriptionScopeMetricDefinition setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String getCategory() {
        return this.category;
    }

    public SubscriptionScopeMetricDefinition setCategory(String category) {
        this.category = category;
        return this;
    }

    public MetricClass getMetricClass() {
        return this.metricClass;
    }

    public SubscriptionScopeMetricDefinition setMetricClass(MetricClass metricClass) {
        this.metricClass = metricClass;
        return this;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public SubscriptionScopeMetricDefinition setUnit(MetricUnit unit) {
        this.unit = unit;
        return this;
    }

    public MetricAggregationType getPrimaryAggregationType() {
        return this.primaryAggregationType;
    }

    public SubscriptionScopeMetricDefinition setPrimaryAggregationType(MetricAggregationType primaryAggregationType) {
        this.primaryAggregationType = primaryAggregationType;
        return this;
    }

    public List<MetricAggregationType> getSupportedAggregationTypes() {
        return this.supportedAggregationTypes;
    }

    public SubscriptionScopeMetricDefinition setSupportedAggregationTypes(List<MetricAggregationType> supportedAggregationTypes) {
        this.supportedAggregationTypes = supportedAggregationTypes;
        return this;
    }

    public List<MetricAvailability> getMetricAvailabilities() {
        return this.metricAvailabilities;
    }

    public SubscriptionScopeMetricDefinition setMetricAvailabilities(List<MetricAvailability> metricAvailabilities) {
        this.metricAvailabilities = metricAvailabilities;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SubscriptionScopeMetricDefinition setId(String id) {
        this.id = id;
        return this;
    }

    public List<LocalizableString> getDimensions() {
        return this.dimensions;
    }

    public SubscriptionScopeMetricDefinition setDimensions(List<LocalizableString> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDimensionRequired", this.isDimensionRequired);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("metricClass", this.metricClass == null ? null : this.metricClass.toString());
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeStringField("primaryAggregationType", this.primaryAggregationType == null ? null : this.primaryAggregationType.toString());
        jsonWriter.writeArrayField("supportedAggregationTypes", this.supportedAggregationTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("metricAvailabilities", this.metricAvailabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionScopeMetricDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionScopeMetricDefinition)jsonReader.readObject(reader -> {
            SubscriptionScopeMetricDefinition deserializedSubscriptionScopeMetricDefinition = new SubscriptionScopeMetricDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isDimensionRequired".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.isDimensionRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.resourceId = reader.getString();
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.namespace = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.name = LocalizableString.fromJson(reader);
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.displayDescription = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.category = reader.getString();
                    continue;
                }
                if ("metricClass".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.metricClass = MetricClass.fromString(reader.getString());
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.unit = MetricUnit.fromString(reader.getString());
                    continue;
                }
                if ("primaryAggregationType".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.primaryAggregationType = MetricAggregationType.fromString(reader.getString());
                    continue;
                }
                if ("supportedAggregationTypes".equals(fieldName)) {
                    List supportedAggregationTypes;
                    deserializedSubscriptionScopeMetricDefinition.supportedAggregationTypes = supportedAggregationTypes = reader.readArray(reader1 -> MetricAggregationType.fromString(reader1.getString()));
                    continue;
                }
                if ("metricAvailabilities".equals(fieldName)) {
                    List metricAvailabilities;
                    deserializedSubscriptionScopeMetricDefinition.metricAvailabilities = metricAvailabilities = reader.readArray(reader1 -> MetricAvailability.fromJson(reader1));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSubscriptionScopeMetricDefinition.id = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedSubscriptionScopeMetricDefinition.dimensions = dimensions = reader.readArray(reader1 -> LocalizableString.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionScopeMetricDefinition;
        });
    }
}

