/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.query.MetricsClientBuilder;
import com.azure.monitor.query.implementation.metrics.models.MetricsHelper;
import com.azure.monitor.query.implementation.metricsbatch.AzureMonitorMetricBatch;
import com.azure.monitor.query.implementation.metricsbatch.models.MetricResultsResponse;
import com.azure.monitor.query.implementation.metricsbatch.models.MetricResultsResponseValuesItem;
import com.azure.monitor.query.implementation.metricsbatch.models.ResourceIdList;
import com.azure.monitor.query.models.AggregationType;
import com.azure.monitor.query.models.MetricsQueryResourcesOptions;
import com.azure.monitor.query.models.MetricsQueryResourcesResult;
import com.azure.monitor.query.models.MetricsQueryResult;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MetricsClientBuilder.class, isAsync=true)
public final class MetricsAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(MetricsAsyncClient.class);
    private final AzureMonitorMetricBatch serviceClient;

    MetricsAsyncClient(AzureMonitorMetricBatch azureMonitorMetricBatch) {
        this.serviceClient = azureMonitorMetricBatch;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsQueryResourcesResult> queryResources(List<String> resourceIds, List<String> metricsNames, String metricsNamespace) {
        return this.queryResourcesWithResponse(resourceIds, metricsNames, metricsNamespace, new MetricsQueryResourcesOptions()).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsQueryResourcesResult>> queryResourcesWithResponse(List<String> resourceIds, List<String> metricsNames, String metricsNamespace, MetricsQueryResourcesOptions options) {
        if (CoreUtils.isNullOrEmpty((Collection)Objects.requireNonNull(resourceIds, "'resourceIds cannot be null."))) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("resourceIds cannot be empty"));
        }
        if (CoreUtils.isNullOrEmpty((Collection)Objects.requireNonNull(metricsNames, "metricsNames cannot be null"))) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("metricsNames cannot be empty"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)Objects.requireNonNull(metricsNamespace, "metricsNamespace cannot be null"))) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("metricsNamespace cannot be empty"));
        }
        String filter = null;
        Duration granularity = null;
        String aggregations = null;
        String startTime = null;
        Integer top = null;
        String orderBy = null;
        String endTime = null;
        String rollupBy = null;
        if (options != null) {
            rollupBy = options.getRollupBy();
            filter = options.getFilter();
            granularity = options.getGranularity();
            if (options.getAggregations() != null) {
                aggregations = options.getAggregations().stream().map(AggregationType::toString).collect(Collectors.joining(","));
            }
            if (options.getTimeInterval() != null) {
                if (options.getTimeInterval().getDuration() != null) {
                    return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Duration is not a supported time interval for batch query. Use startTime and endTime instead."));
                }
                if (options.getTimeInterval().getStartTime() != null) {
                    startTime = options.getTimeInterval().getStartTime().toString();
                }
                if (options.getTimeInterval().getEndTime() != null) {
                    endTime = options.getTimeInterval().getEndTime().toString();
                }
            }
            top = options.getTop();
            orderBy = options.getOrderBy();
        }
        String subscriptionId = MetricsHelper.getSubscriptionFromResourceId(resourceIds.get(0));
        ResourceIdList resourceIdList = new ResourceIdList();
        resourceIdList.setResourceids(resourceIds);
        Mono<Response<MetricResultsResponse>> responseMono = this.serviceClient.getMetricsBatches().batchWithResponseAsync(subscriptionId, metricsNamespace, metricsNames, resourceIdList, startTime, endTime, granularity, aggregations, top, orderBy, filter, rollupBy);
        return responseMono.map(response -> {
            MetricResultsResponse value = (MetricResultsResponse)response.getValue();
            List<MetricResultsResponseValuesItem> values = value.getValues();
            List<MetricsQueryResult> metricsQueryResults = values.stream().map(result -> MetricsHelper.mapToMetricsQueryResult(result)).collect(Collectors.toList());
            MetricsQueryResourcesResult metricsQueryResourcesResult = new MetricsQueryResourcesResult(metricsQueryResults);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)metricsQueryResourcesResult);
        });
    }
}

