/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.monitor.query.MetricsAsyncClient;
import com.azure.monitor.query.MetricsClient;
import com.azure.monitor.query.MetricsServiceVersion;
import com.azure.monitor.query.implementation.metricsbatch.AzureMonitorMetricBatchBuilder;
import com.azure.monitor.query.models.MetricsAudience;

@ServiceClientBuilder(serviceClients={MetricsClient.class, MetricsAsyncClient.class})
public final class MetricsClientBuilder
implements EndpointTrait<MetricsClientBuilder>,
HttpTrait<MetricsClientBuilder>,
ConfigurationTrait<MetricsClientBuilder>,
TokenCredentialTrait<MetricsClientBuilder> {
    private final AzureMonitorMetricBatchBuilder innerMetricsBatchBuilder = new AzureMonitorMetricBatchBuilder();

    public MetricsClientBuilder endpoint(String endpoint) {
        this.innerMetricsBatchBuilder.endpoint(endpoint);
        return this;
    }

    public MetricsClientBuilder audience(MetricsAudience audience) {
        this.innerMetricsBatchBuilder.audience(audience);
        return this;
    }

    public MetricsClientBuilder pipeline(HttpPipeline pipeline) {
        this.innerMetricsBatchBuilder.pipeline(pipeline);
        return this;
    }

    public MetricsClientBuilder httpClient(HttpClient httpClient) {
        this.innerMetricsBatchBuilder.httpClient(httpClient);
        return this;
    }

    public MetricsClientBuilder configuration(Configuration configuration) {
        this.innerMetricsBatchBuilder.configuration(configuration);
        return this;
    }

    public MetricsClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.innerMetricsBatchBuilder.httpLogOptions(httpLogOptions);
        return this;
    }

    public MetricsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.innerMetricsBatchBuilder.retryPolicy(retryPolicy);
        return this;
    }

    public MetricsClientBuilder retryOptions(RetryOptions retryOptions) {
        this.innerMetricsBatchBuilder.retryOptions(retryOptions);
        return this;
    }

    public MetricsClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.innerMetricsBatchBuilder.addPolicy(customPolicy);
        return this;
    }

    public MetricsClientBuilder credential(TokenCredential tokenCredential) {
        this.innerMetricsBatchBuilder.credential(tokenCredential);
        return this;
    }

    public MetricsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.innerMetricsBatchBuilder.clientOptions(clientOptions);
        return this;
    }

    public MetricsClientBuilder serviceVersion(MetricsServiceVersion serviceVersion) {
        this.innerMetricsBatchBuilder.apiVersion(serviceVersion.getVersion());
        return this;
    }

    public MetricsClient buildClient() {
        return new MetricsClient(this.innerMetricsBatchBuilder.buildClient());
    }

    public MetricsAsyncClient buildAsyncClient() {
        return new MetricsAsyncClient(this.innerMetricsBatchBuilder.buildClient());
    }
}

