/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.models.ResponseError;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.monitor.query.MetricsQueryClientBuilder;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.implementation.metrics.MonitorManagementClientImpl;
import com.azure.monitor.query.implementation.metrics.models.ErrorResponseException;
import com.azure.monitor.query.implementation.metrics.models.MetricsHelper;
import com.azure.monitor.query.implementation.metrics.models.MetricsResponse;
import com.azure.monitor.query.implementation.metrics.models.ResultType;
import com.azure.monitor.query.implementation.metricsdefinitions.MetricsDefinitionsClientImpl;
import com.azure.monitor.query.implementation.metricsnamespaces.MetricsNamespacesClientImpl;
import com.azure.monitor.query.models.MetricDefinition;
import com.azure.monitor.query.models.MetricNamespace;
import com.azure.monitor.query.models.MetricsQueryOptions;
import com.azure.monitor.query.models.MetricsQueryResult;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MetricsQueryClientBuilder.class, isAsync=true)
public final class MetricsQueryAsyncClient {
    private final MonitorManagementClientImpl metricsClient;
    private final MetricsNamespacesClientImpl metricsNamespaceClient;
    private final MetricsDefinitionsClientImpl metricsDefinitionsClient;

    MetricsQueryAsyncClient(MonitorManagementClientImpl metricsClient, MetricsNamespacesClientImpl metricsNamespaceClient, MetricsDefinitionsClientImpl metricsDefinitionsClients) {
        this.metricsClient = metricsClient;
        this.metricsNamespaceClient = metricsNamespaceClient;
        this.metricsDefinitionsClient = metricsDefinitionsClients;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsQueryResult> queryResource(String resourceUri, List<String> metricsNames) {
        return this.queryResourceWithResponse(resourceUri, metricsNames, new MetricsQueryOptions()).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsQueryResult>> queryResourceWithResponse(String resourceUri, List<String> metricsNames, MetricsQueryOptions options) {
        return FluxUtil.withContext(context -> this.queryResourceWithResponse(resourceUri, metricsNames, options, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime) {
        return this.metricsNamespaceClient.getMetricNamespaces().listAsync(resourceUri, startTime == null ? null : startTime.toString()).mapPage(MetricsHelper::mapMetricNamespace);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricDefinition> listMetricDefinitions(String resourceUri) {
        return this.listMetricDefinitions(resourceUri, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricDefinition> listMetricDefinitions(String resourceUri, String metricsNamespace) {
        return this.metricsDefinitionsClient.getMetricDefinitions().listAsync(resourceUri, metricsNamespace).mapPage(MetricsHelper::mapToMetricDefinition);
    }

    PagedFlux<MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime, Context context) {
        return this.metricsNamespaceClient.getMetricNamespaces().listAsync(resourceUri, startTime == null ? null : startTime.toString(), context).mapPage(MetricsHelper::mapMetricNamespace);
    }

    PagedFlux<MetricDefinition> listMetricDefinitions(String resourceUri, String metricsNamespace, Context context) {
        return this.metricsDefinitionsClient.getMetricDefinitions().listAsync(resourceUri, metricsNamespace, context).mapPage(MetricsHelper::mapToMetricDefinition);
    }

    Mono<Response<MetricsQueryResult>> queryResourceWithResponse(String resourceUri, List<String> metricsNames, MetricsQueryOptions options, Context context) {
        String aggregation = null;
        if (!CoreUtils.isNullOrEmpty(options.getAggregations())) {
            aggregation = options.getAggregations().stream().map(type -> type.toString()).collect(Collectors.joining(","));
        }
        String timespan = options.getTimeInterval() == null ? null : LogsQueryHelper.toIso8601Format(options.getTimeInterval());
        return this.metricsClient.getMetrics().listWithResponseAsync(resourceUri, timespan, options.getGranularity(), String.join((CharSequence)",", metricsNames), aggregation, options.getTop(), options.getOrderBy(), options.getFilter(), ResultType.DATA, options.getMetricNamespace(), null, null, null, context).map(response -> MetricsHelper.convertToMetricsQueryResult((Response<MetricsResponse>)response)).onErrorMap(ErrorResponseException.class, ex -> new HttpResponseException(ex.getMessage(), ex.getResponse(), (Object)new ResponseError(ex.getValue().getCode(), ex.getValue().getMessage())));
    }
}

