/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.BatchQueryResults;
import java.io.IOException;
import java.util.Map;

public final class BatchQueryResponse
implements JsonSerializable<BatchQueryResponse> {
    private String id;
    private Integer status;
    private BatchQueryResults body;
    private Map<String, String> headers;

    public String getId() {
        return this.id;
    }

    public BatchQueryResponse setId(String id) {
        this.id = id;
        return this;
    }

    public Integer getStatus() {
        return this.status;
    }

    public BatchQueryResponse setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public BatchQueryResults getBody() {
        return this.body;
    }

    public BatchQueryResponse setBody(BatchQueryResults body) {
        this.body = body;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public BatchQueryResponse setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeNumberField("status", (Number)this.status);
        jsonWriter.writeJsonField("body", (JsonSerializable)this.body);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BatchQueryResponse fromJson(JsonReader jsonReader) throws IOException {
        return (BatchQueryResponse)jsonReader.readObject(reader -> {
            BatchQueryResponse deserializedBatchQueryResponse = new BatchQueryResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBatchQueryResponse.id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedBatchQueryResponse.status = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedBatchQueryResponse.body = BatchQueryResults.fromJson(reader);
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    Map headers;
                    deserializedBatchQueryResponse.headers = headers = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchQueryResponse;
        });
    }
}

