/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.BatchQueryRequest;
import java.io.IOException;
import java.util.List;

public final class BatchRequest
implements JsonSerializable<BatchRequest> {
    private final List<BatchQueryRequest> requests;

    public BatchRequest(List<BatchQueryRequest> requests) {
        this.requests = requests;
    }

    public List<BatchQueryRequest> getRequests() {
        return this.requests;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("requests", this.requests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchRequest fromJson(JsonReader jsonReader) throws IOException {
        return (BatchRequest)jsonReader.readObject(reader -> {
            boolean requestsFound = false;
            List requests = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requests".equals(fieldName)) {
                    requests = reader.readArray(reader1 -> BatchQueryRequest.fromJson(reader1));
                    requestsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (requestsFound) {
                return new BatchRequest(requests);
            }
            throw new IllegalStateException("Missing required property: requests");
        });
    }
}

