/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataQueryRelated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MetadataQuery
implements JsonSerializable<MetadataQuery> {
    private final String id;
    private String displayName;
    private String description;
    private final String body;
    private List<String> labels;
    private Object tags;
    private Object properties;
    private MetadataQueryRelated related;

    public MetadataQuery(String id, String body) {
        this.id = id;
        this.body = body;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MetadataQuery setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataQuery setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public MetadataQuery setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public Object getTags() {
        return this.tags;
    }

    public MetadataQuery setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    public Object getProperties() {
        return this.properties;
    }

    public MetadataQuery setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public MetadataQueryRelated getRelated() {
        return this.related;
    }

    public MetadataQuery setRelated(MetadataQueryRelated related) {
        this.related = related;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeUntypedField("tags", this.tags);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        return jsonWriter.writeEndObject();
    }

    public static MetadataQuery fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataQuery)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean bodyFound = false;
            String body = null;
            String displayName = null;
            String description = null;
            List labels = null;
            Object tags = null;
            Object properties = null;
            MetadataQueryRelated related = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("body".equals(fieldName)) {
                    body = reader.getString();
                    bodyFound = true;
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readUntyped();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readUntyped();
                    continue;
                }
                if ("related".equals(fieldName)) {
                    related = MetadataQueryRelated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && bodyFound) {
                MetadataQuery deserializedMetadataQuery = new MetadataQuery(id, body);
                deserializedMetadataQuery.displayName = displayName;
                deserializedMetadataQuery.description = description;
                deserializedMetadataQuery.labels = labels;
                deserializedMetadataQuery.tags = tags;
                deserializedMetadataQuery.properties = properties;
                deserializedMetadataQuery.related = related;
                return deserializedMetadataQuery;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!bodyFound) {
                missingProperties.add("body");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

