/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataResourceTypeRelated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MetadataResourceType
implements JsonSerializable<MetadataResourceType> {
    private final String id;
    private final String type;
    private String displayName;
    private String description;
    private List<String> labels;
    private Object tags;
    private Object properties;
    private MetadataResourceTypeRelated related;

    public MetadataResourceType(String id, String type) {
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MetadataResourceType setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataResourceType setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public MetadataResourceType setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public Object getTags() {
        return this.tags;
    }

    public MetadataResourceType setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    public Object getProperties() {
        return this.properties;
    }

    public MetadataResourceType setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public MetadataResourceTypeRelated getRelated() {
        return this.related;
    }

    public MetadataResourceType setRelated(MetadataResourceTypeRelated related) {
        this.related = related;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeUntypedField("tags", this.tags);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        return jsonWriter.writeEndObject();
    }

    public static MetadataResourceType fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataResourceType)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean typeFound = false;
            String type = null;
            String displayName = null;
            String description = null;
            List labels = null;
            Object tags = null;
            Object properties = null;
            MetadataResourceTypeRelated related = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    typeFound = true;
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readUntyped();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readUntyped();
                    continue;
                }
                if ("related".equals(fieldName)) {
                    related = MetadataResourceTypeRelated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && typeFound) {
                MetadataResourceType deserializedMetadataResourceType = new MetadataResourceType(id, type);
                deserializedMetadataResourceType.displayName = displayName;
                deserializedMetadataResourceType.description = description;
                deserializedMetadataResourceType.labels = labels;
                deserializedMetadataResourceType.tags = tags;
                deserializedMetadataResourceType.properties = properties;
                deserializedMetadataResourceType.related = related;
                return deserializedMetadataResourceType;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!typeFound) {
                missingProperties.add("type");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

