/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataSolutionRelated;
import java.io.IOException;
import java.util.ArrayList;

public final class MetadataSolution
implements JsonSerializable<MetadataSolution> {
    private final String id;
    private final String name;
    private String displayName;
    private String description;
    private Object tags;
    private Object properties;
    private final MetadataSolutionRelated related;

    public MetadataSolution(String id, String name, MetadataSolutionRelated related) {
        this.id = id;
        this.name = name;
        this.related = related;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MetadataSolution setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataSolution setDescription(String description) {
        this.description = description;
        return this;
    }

    public Object getTags() {
        return this.tags;
    }

    public MetadataSolution setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    public Object getProperties() {
        return this.properties;
    }

    public MetadataSolution setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public MetadataSolutionRelated getRelated() {
        return this.related;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("tags", this.tags);
        jsonWriter.writeUntypedField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    public static MetadataSolution fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataSolution)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean nameFound = false;
            String name = null;
            boolean relatedFound = false;
            MetadataSolutionRelated related = null;
            String displayName = null;
            String description = null;
            Object tags = null;
            Object properties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("related".equals(fieldName)) {
                    related = MetadataSolutionRelated.fromJson(reader);
                    relatedFound = true;
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readUntyped();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && nameFound && relatedFound) {
                MetadataSolution deserializedMetadataSolution = new MetadataSolution(id, name, related);
                deserializedMetadataSolution.displayName = displayName;
                deserializedMetadataSolution.description = description;
                deserializedMetadataSolution.tags = tags;
                deserializedMetadataSolution.properties = properties;
                return deserializedMetadataSolution;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!relatedFound) {
                missingProperties.add("related");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

