/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.ErrorInfo;
import com.azure.monitor.query.implementation.logs.models.Table;
import java.io.IOException;
import java.util.List;

public final class QueryResults
implements JsonSerializable<QueryResults> {
    private final List<Table> tables;
    private Object statistics;
    private Object render;
    private ErrorInfo error;

    public QueryResults(List<Table> tables) {
        this.tables = tables;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public Object getStatistics() {
        return this.statistics;
    }

    public QueryResults setStatistics(Object statistics) {
        this.statistics = statistics;
        return this;
    }

    public Object getRender() {
        return this.render;
    }

    public QueryResults setRender(Object render) {
        this.render = render;
        return this;
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public QueryResults setError(ErrorInfo error) {
        this.error = error;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeUntypedField("statistics", this.statistics);
        jsonWriter.writeUntypedField("render", this.render);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static QueryResults fromJson(JsonReader jsonReader) throws IOException {
        return (QueryResults)jsonReader.readObject(reader -> {
            boolean tablesFound = false;
            List tables = null;
            Object statistics = null;
            Object render = null;
            ErrorInfo error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tables".equals(fieldName)) {
                    tables = reader.readArray(reader1 -> Table.fromJson(reader1));
                    tablesFound = true;
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    statistics = reader.readUntyped();
                    continue;
                }
                if ("render".equals(fieldName)) {
                    render = reader.readUntyped();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ErrorInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (tablesFound) {
                QueryResults deserializedQueryResults = new QueryResults(tables);
                deserializedQueryResults.statistics = statistics;
                deserializedQueryResults.render = render;
                deserializedQueryResults.error = error;
                return deserializedQueryResults;
            }
            throw new IllegalStateException("Missing required property: tables");
        });
    }
}

