/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsbatch;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.metricsbatch.AzureMonitorMetricBatch;
import com.azure.monitor.query.implementation.metricsbatch.models.ErrorResponseException;
import com.azure.monitor.query.implementation.metricsbatch.models.MetricResultsResponse;
import com.azure.monitor.query.implementation.metricsbatch.models.ResourceIdList;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class MetricsBatches {
    private final MetricsBatchesService service;
    private final AzureMonitorMetricBatch client;

    MetricsBatches(AzureMonitorMetricBatch client) {
        this.service = (MetricsBatchesService)RestProxy.create(MetricsBatchesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricResultsResponse>> batchWithResponseAsync(String subscriptionId, String metricnamespace, List<String> metricnames, ResourceIdList batchRequest, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, String rollupby) {
        String accept = "application/json";
        String metricnamesConverted = metricnames.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.batch(this.client.getEndpoint(), subscriptionId, starttime, endtime, interval, metricnamespace, metricnamesConverted, aggregation, top, orderBy, filter, rollupby, this.client.getApiVersion(), batchRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricResultsResponse>> batchWithResponseAsync(String subscriptionId, String metricnamespace, List<String> metricnames, ResourceIdList batchRequest, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, String rollupby, Context context) {
        String accept = "application/json";
        String metricnamesConverted = metricnames.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.batch(this.client.getEndpoint(), subscriptionId, starttime, endtime, interval, metricnamespace, metricnamesConverted, aggregation, top, orderBy, filter, rollupby, this.client.getApiVersion(), batchRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricResultsResponse> batchAsync(String subscriptionId, String metricnamespace, List<String> metricnames, ResourceIdList batchRequest, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, String rollupby) {
        return this.batchWithResponseAsync(subscriptionId, metricnamespace, metricnames, batchRequest, starttime, endtime, interval, aggregation, top, orderBy, filter, rollupby).flatMap(res -> Mono.justOrEmpty((Object)((MetricResultsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricResultsResponse> batchAsync(String subscriptionId, String metricnamespace, List<String> metricnames, ResourceIdList batchRequest, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, String rollupby, Context context) {
        return this.batchWithResponseAsync(subscriptionId, metricnamespace, metricnames, batchRequest, starttime, endtime, interval, aggregation, top, orderBy, filter, rollupby, context).flatMap(res -> Mono.justOrEmpty((Object)((MetricResultsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricResultsResponse> batchWithResponse(String subscriptionId, String metricnamespace, List<String> metricnames, ResourceIdList batchRequest, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, String rollupby, Context context) {
        String accept = "application/json";
        String metricnamesConverted = metricnames.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.batchSync(this.client.getEndpoint(), subscriptionId, starttime, endtime, interval, metricnamespace, metricnamesConverted, aggregation, top, orderBy, filter, rollupby, this.client.getApiVersion(), batchRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricResultsResponse batch(String subscriptionId, String metricnamespace, List<String> metricnames, ResourceIdList batchRequest, String starttime, String endtime, Duration interval, String aggregation, Integer top, String orderBy, String filter, String rollupby) {
        return (MetricResultsResponse)this.batchWithResponse(subscriptionId, metricnamespace, metricnames, batchRequest, starttime, endtime, interval, aggregation, top, orderBy, filter, rollupby, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureMonitorMetricBa")
    public static interface MetricsBatchesService {
        @Post(value="/subscriptions/{subscriptionId}/metrics:getBatch")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<MetricResultsResponse>> batch(@HostParam(value="endpoint") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="starttime") String var3, @QueryParam(value="endtime") String var4, @QueryParam(value="interval") Duration var5, @QueryParam(value="metricnamespace") String var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="filter") String var11, @QueryParam(value="rollupby") String var12, @QueryParam(value="api-version") String var13, @BodyParam(value="application/json") ResourceIdList var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Post(value="/subscriptions/{subscriptionId}/metrics:getBatch")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<MetricResultsResponse> batchSync(@HostParam(value="endpoint") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="starttime") String var3, @QueryParam(value="endtime") String var4, @QueryParam(value="interval") Duration var5, @QueryParam(value="metricnamespace") String var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="filter") String var11, @QueryParam(value="rollupby") String var12, @QueryParam(value="api-version") String var13, @BodyParam(value="application/json") ResourceIdList var14, @HeaderParam(value="Accept") String var15, Context var16);
    }
}

