/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metricsdefinitions;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.metricsdefinitions.MetricDefinitionsImpl;

public final class MetricsDefinitionsClientImpl {
    private final String subscriptionId;
    private final String host;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final MetricDefinitionsImpl metricDefinitions;

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getHost() {
        return this.host;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public MetricDefinitionsImpl getMetricDefinitions() {
        return this.metricDefinitions;
    }

    MetricsDefinitionsClientImpl(String subscriptionId, String host, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), subscriptionId, host, apiVersion);
    }

    MetricsDefinitionsClientImpl(HttpPipeline httpPipeline, String subscriptionId, String host, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), subscriptionId, host, apiVersion);
    }

    MetricsDefinitionsClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String subscriptionId, String host, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.subscriptionId = subscriptionId;
        this.host = host;
        this.apiVersion = apiVersion;
        this.metricDefinitions = new MetricDefinitionsImpl(this);
    }
}

