/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.models.LogsBatchQueryResult;
import java.util.List;

public final class LogsBatchQueryResultCollection {
    private final ClientLogger logger = new ClientLogger(LogsBatchQueryResultCollection.class);
    private final List<LogsBatchQueryResult> batchResults;

    public LogsBatchQueryResultCollection(List<LogsBatchQueryResult> batchResults) {
        this.batchResults = batchResults;
    }

    public List<LogsBatchQueryResult> getBatchResults() {
        return this.batchResults;
    }

    public <T> List<T> getResult(String queryId, Class<T> type) {
        return this.batchResults.stream().filter(result -> result.getId().equals(queryId)).map(queryResult -> LogsQueryHelper.toObject(queryResult.getTable(), type)).findFirst().orElseThrow(() -> this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(queryId + " not found in the batch result")));
    }

    public LogsBatchQueryResult getResult(String queryId) {
        return this.batchResults.stream().filter(result -> result.getId().equals(queryId)).findFirst().orElseThrow(() -> this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(queryId + " not found in the batch result")));
    }
}

