/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.models;

import com.azure.core.util.CoreUtils;
import com.azure.monitor.query.models.MetricResult;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public final class MetricsQueryResult {
    private final Integer cost;
    private final QueryTimeInterval timeInterval;
    private final Duration granularity;
    private final String namespace;
    private final String resourceRegion;
    private final List<MetricResult> metrics;
    private String resourceId;

    public MetricsQueryResult(Integer cost, QueryTimeInterval timeInterval, Duration granularity, String namespace, String resourceRegion, List<MetricResult> metrics) {
        this.cost = cost;
        this.timeInterval = timeInterval;
        this.granularity = granularity;
        this.namespace = namespace;
        this.resourceRegion = resourceRegion;
        this.metrics = metrics;
    }

    public Integer getCost() {
        return this.cost;
    }

    public QueryTimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public Duration getGranularity() {
        return this.granularity;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getResourceRegion() {
        return this.resourceRegion;
    }

    public List<MetricResult> getMetrics() {
        return this.metrics;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public MetricResult getMetricByName(String metricName) {
        Objects.requireNonNull(metricName, "'metricName' cannot be null");
        if (CoreUtils.isNullOrEmpty(this.metrics)) {
            return null;
        }
        return this.metrics.stream().filter(metricResult -> metricResult.getMetricName().equals(metricName)).findFirst().orElse(null);
    }
}

