/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.MetadataWorkspaceRelated;
import java.io.IOException;
import java.util.ArrayList;

public final class MetadataWorkspace
implements JsonSerializable<MetadataWorkspace> {
    private final String id;
    private final String resourceId;
    private final String name;
    private final String region;
    private MetadataWorkspaceRelated related;

    public MetadataWorkspace(String id, String resourceId, String name, String region) {
        this.id = id;
        this.resourceId = resourceId;
        this.name = name;
        this.region = region;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public MetadataWorkspaceRelated getRelated() {
        return this.related;
    }

    public MetadataWorkspace setRelated(MetadataWorkspaceRelated related) {
        this.related = related;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeJsonField("related", (JsonSerializable)this.related);
        return jsonWriter.writeEndObject();
    }

    public static MetadataWorkspace fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataWorkspace)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean resourceIdFound = false;
            String resourceId = null;
            boolean nameFound = false;
            String name = null;
            boolean regionFound = false;
            String region = null;
            MetadataWorkspaceRelated related = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    resourceId = reader.getString();
                    resourceIdFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("region".equals(fieldName)) {
                    region = reader.getString();
                    regionFound = true;
                    continue;
                }
                if ("related".equals(fieldName)) {
                    related = MetadataWorkspaceRelated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && resourceIdFound && nameFound && regionFound) {
                MetadataWorkspace deserializedMetadataWorkspace = new MetadataWorkspace(id, resourceId, name, region);
                deserializedMetadataWorkspace.related = related;
                return deserializedMetadataWorkspace;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!resourceIdFound) {
                missingProperties.add("resourceId");
            }
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!regionFound) {
                missingProperties.add("region");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

