/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class QueryBody
implements JsonSerializable<QueryBody> {
    private final String query;
    private String timespan;
    private List<String> workspaces;

    public QueryBody(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public String getTimespan() {
        return this.timespan;
    }

    public QueryBody setTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    public List<String> getWorkspaces() {
        return this.workspaces;
    }

    public QueryBody setWorkspaces(List<String> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeArrayField("workspaces", this.workspaces, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static QueryBody fromJson(JsonReader jsonReader) throws IOException {
        return (QueryBody)jsonReader.readObject(reader -> {
            boolean queryFound = false;
            String query = null;
            String timespan = null;
            List workspaces = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("query".equals(fieldName)) {
                    query = reader.getString();
                    queryFound = true;
                    continue;
                }
                if ("timespan".equals(fieldName)) {
                    timespan = reader.getString();
                    continue;
                }
                if ("workspaces".equals(fieldName)) {
                    workspaces = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (queryFound) {
                QueryBody deserializedQueryBody = new QueryBody(query);
                deserializedQueryBody.timespan = timespan;
                deserializedQueryBody.workspaces = workspaces;
                return deserializedQueryBody;
            }
            throw new IllegalStateException("Missing required property: query");
        });
    }
}

