/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.logs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.monitor.query.implementation.logs.models.Column;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Table
implements JsonSerializable<Table> {
    private final String name;
    private final List<Column> columns;
    private final List<List<Object>> rows;

    public Table(String name, List<Column> columns, List<List<Object>> rows) {
        this.name = name;
        this.columns = columns;
        this.rows = rows;
    }

    public String getName() {
        return this.name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("rows", this.rows, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeUntyped(element1)));
        return jsonWriter.writeEndObject();
    }

    public static Table fromJson(JsonReader jsonReader) throws IOException {
        return (Table)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean columnsFound = false;
            List columns = null;
            boolean rowsFound = false;
            List rows = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    columns = reader.readArray(reader1 -> Column.fromJson(reader1));
                    columnsFound = true;
                    continue;
                }
                if ("rows".equals(fieldName)) {
                    rows = reader.readArray(reader1 -> reader1.readArray(reader2 -> reader2.readUntyped()));
                    rowsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && columnsFound && rowsFound) {
                return new Table(name, columns, rows);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!columnsFound) {
                missingProperties.add("columns");
            }
            if (!rowsFound) {
                missingProperties.add("rows");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

