/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metrics;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.monitor.query.implementation.metrics.MonitorManagementClientImpl;
import com.azure.monitor.query.implementation.metrics.models.ErrorContractException;
import com.azure.monitor.query.implementation.metrics.models.ErrorResponseException;
import com.azure.monitor.query.implementation.metrics.models.MetricResultType;
import com.azure.monitor.query.implementation.metrics.models.MetricsResponse;
import com.azure.monitor.query.implementation.metrics.models.ResultType;
import com.azure.monitor.query.implementation.metrics.models.SubscriptionScopeMetricsRequestBodyParameters;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class MetricsImpl {
    private final MetricsService service;
    private final MonitorManagementClientImpl client;

    MetricsImpl(MonitorManagementClientImpl client) {
        this.service = (MetricsService)RestProxy.create(MetricsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listAtSubscriptionScopeWithResponseAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby) {
        return FluxUtil.withContext(context -> this.listAtSubscriptionScopeWithResponseAsync(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listAtSubscriptionScopeWithResponseAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, Context context) {
        String accept = "application/json";
        return this.service.listAtSubscriptionScope(this.client.getHost(), this.client.getSubscriptionId(), this.client.getApiVersion(), region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAtSubscriptionScopeAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby) {
        return this.listAtSubscriptionScopeWithResponseAsync(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby).flatMap(res -> Mono.justOrEmpty((Object)((MetricsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAtSubscriptionScopeAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, Context context) {
        return this.listAtSubscriptionScopeWithResponseAsync(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, context).flatMap(res -> Mono.justOrEmpty((Object)((MetricsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricsResponse> listAtSubscriptionScopeWithResponse(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, Context context) {
        String accept = "application/json";
        return this.service.listAtSubscriptionScopeSync(this.client.getHost(), this.client.getSubscriptionId(), this.client.getApiVersion(), region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricsResponse listAtSubscriptionScope(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby) {
        return (MetricsResponse)this.listAtSubscriptionScopeWithResponse(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listAtSubscriptionScopePostWithResponseAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, SubscriptionScopeMetricsRequestBodyParameters body) {
        return FluxUtil.withContext(context -> this.listAtSubscriptionScopePostWithResponseAsync(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listAtSubscriptionScopePostWithResponseAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, SubscriptionScopeMetricsRequestBodyParameters body, Context context) {
        String accept = "application/json";
        return this.service.listAtSubscriptionScopePost(this.client.getHost(), this.client.getSubscriptionId(), this.client.getApiVersion(), region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAtSubscriptionScopePostAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, SubscriptionScopeMetricsRequestBodyParameters body) {
        return this.listAtSubscriptionScopePostWithResponseAsync(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, body).flatMap(res -> Mono.justOrEmpty((Object)((MetricsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAtSubscriptionScopePostAsync(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, SubscriptionScopeMetricsRequestBodyParameters body, Context context) {
        return this.listAtSubscriptionScopePostWithResponseAsync(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, body, context).flatMap(res -> Mono.justOrEmpty((Object)((MetricsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricsResponse> listAtSubscriptionScopePostWithResponse(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, SubscriptionScopeMetricsRequestBodyParameters body, Context context) {
        String accept = "application/json";
        return this.service.listAtSubscriptionScopePostSync(this.client.getHost(), this.client.getSubscriptionId(), this.client.getApiVersion(), region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricsResponse listAtSubscriptionScopePost(String region, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, MetricResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, SubscriptionScopeMetricsRequestBodyParameters body) {
        return (MetricsResponse)this.listAtSubscriptionScopePostWithResponse(region, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listWithResponseAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby) {
        return FluxUtil.withContext(context -> this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponse>> listWithResponseAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, Context context) {
        String accept = "application/json";
        return this.service.list(this.client.getHost(), resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, this.client.getApiVersion(), metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby) {
        return this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby).flatMap(res -> Mono.justOrEmpty((Object)((MetricsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponse> listAsync(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, Context context) {
        return this.listWithResponseAsync(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, context).flatMap(res -> Mono.justOrEmpty((Object)((MetricsResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricsResponse> listWithResponse(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby, Context context) {
        String accept = "application/json";
        return this.service.listSync(this.client.getHost(), resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, this.client.getApiVersion(), metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricsResponse list(String resourceUri, String timespan, Duration interval, String metricnames, String aggregation, Integer top, String orderBy, String filter, ResultType resultType, String metricnamespace, Boolean autoAdjustTimegrain, Boolean validateDimensions, String rollupby) {
        return (MetricsResponse)this.listWithResponse(resourceUri, timespan, interval, metricnames, aggregation, top, orderBy, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, rollupby, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureMonitorMetricsD")
    public static interface MetricsService {
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<MetricsResponse>> listAtSubscriptionScope(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="region") String var4, @QueryParam(value="timespan") String var5, @QueryParam(value="interval") Duration var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="$filter") String var11, @QueryParam(value="resultType") MetricResultType var12, @QueryParam(value="metricnamespace") String var13, @QueryParam(value="AutoAdjustTimegrain") Boolean var14, @QueryParam(value="ValidateDimensions") Boolean var15, @QueryParam(value="rollupby") String var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Response<MetricsResponse> listAtSubscriptionScopeSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="region") String var4, @QueryParam(value="timespan") String var5, @QueryParam(value="interval") Duration var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="$filter") String var11, @QueryParam(value="resultType") MetricResultType var12, @QueryParam(value="metricnamespace") String var13, @QueryParam(value="AutoAdjustTimegrain") Boolean var14, @QueryParam(value="ValidateDimensions") Boolean var15, @QueryParam(value="rollupby") String var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<MetricsResponse>> listAtSubscriptionScopePost(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="region") String var4, @QueryParam(value="timespan") String var5, @QueryParam(value="interval") Duration var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="$filter") String var11, @QueryParam(value="resultType") MetricResultType var12, @QueryParam(value="metricnamespace") String var13, @QueryParam(value="AutoAdjustTimegrain") Boolean var14, @QueryParam(value="ValidateDimensions") Boolean var15, @QueryParam(value="rollupby") String var16, @BodyParam(value="application/json") SubscriptionScopeMetricsRequestBodyParameters var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Response<MetricsResponse> listAtSubscriptionScopePostSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="region") String var4, @QueryParam(value="timespan") String var5, @QueryParam(value="interval") Duration var6, @QueryParam(value="metricnames") String var7, @QueryParam(value="aggregation") String var8, @QueryParam(value="top") Integer var9, @QueryParam(value="orderby") String var10, @QueryParam(value="$filter") String var11, @QueryParam(value="resultType") MetricResultType var12, @QueryParam(value="metricnamespace") String var13, @QueryParam(value="AutoAdjustTimegrain") Boolean var14, @QueryParam(value="ValidateDimensions") Boolean var15, @QueryParam(value="rollupby") String var16, @BodyParam(value="application/json") SubscriptionScopeMetricsRequestBodyParameters var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Get(value="/{resourceUri}/providers/Microsoft.Insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<MetricsResponse>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="timespan") String var3, @QueryParam(value="interval") Duration var4, @QueryParam(value="metricnames") String var5, @QueryParam(value="aggregation") String var6, @QueryParam(value="top") Integer var7, @QueryParam(value="orderby") String var8, @QueryParam(value="$filter") String var9, @QueryParam(value="resultType") ResultType var10, @QueryParam(value="api-version") String var11, @QueryParam(value="metricnamespace") String var12, @QueryParam(value="AutoAdjustTimegrain") Boolean var13, @QueryParam(value="ValidateDimensions") Boolean var14, @QueryParam(value="rollupby") String var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Get(value="/{resourceUri}/providers/Microsoft.Insights/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<MetricsResponse> listSync(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="timespan") String var3, @QueryParam(value="interval") Duration var4, @QueryParam(value="metricnames") String var5, @QueryParam(value="aggregation") String var6, @QueryParam(value="top") Integer var7, @QueryParam(value="orderby") String var8, @QueryParam(value="$filter") String var9, @QueryParam(value="resultType") ResultType var10, @QueryParam(value="api-version") String var11, @QueryParam(value="metricnamespace") String var12, @QueryParam(value="AutoAdjustTimegrain") Boolean var13, @QueryParam(value="ValidateDimensions") Boolean var14, @QueryParam(value="rollupby") String var15, @HeaderParam(value="Accept") String var16, Context var17);
    }
}

